/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions.query;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class QueryWrapper<T>
extends AbstractWrapper<T, String, QueryWrapper<T>> {
    private String[] sqlSelect;
    private String[] excludeColumns = new String[0];

    public QueryWrapper() {
        this(null, null);
    }

    public QueryWrapper(T entity) {
        this(entity, null);
    }

    public QueryWrapper(T entity, String ... column) {
        this.sqlSelect = column;
        this.entity = entity;
        this.initNeed();
    }

    private QueryWrapper(T entity, String[] sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments) {
        this.entity = entity;
        this.sqlSelect = sqlSelect;
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
    }

    @Override
    public String getSqlSelect() {
        if (ArrayUtils.isNotEmpty(this.sqlSelect)) {
            List<String> excludeColumnList = Arrays.asList(this.excludeColumns);
            this.sqlSelect = (String[])Arrays.stream(this.sqlSelect).filter($this -> !excludeColumnList.contains($this)).toArray(String[]::new);
        } else if (this.entityClass != null) {
            this.sqlSelect = TableInfoHelper.getTableColumns(this.entityClass, this.excludeColumns);
        }
        return ArrayUtils.isNotEmpty(this.sqlSelect) ? SqlUtils.stripSqlInjection(Arrays.stream(this.sqlSelect).collect(Collectors.joining(","))) : null;
    }

    public QueryWrapper<T> select(String ... sqlSelect) {
        if (ArrayUtils.isNotEmpty(sqlSelect)) {
            this.sqlSelect = sqlSelect;
        }
        return (QueryWrapper)this.typedThis;
    }

    public QueryWrapper<T> excludeColumns(Class<T> entityClass, String ... excludeColumns) {
        Assert.notNull(entityClass, "entityClass is not null");
        Assert.notEmpty(excludeColumns, "excludeColumns is not empty");
        this.excludeColumns = excludeColumns;
        this.entityClass = entityClass;
        return (QueryWrapper)this.typedThis;
    }

    public QueryWrapper<T> excludeColumns(String ... excludeColumns) {
        Assert.notNull(this.entity, "entity is not null");
        return this.excludeColumns(this.entity.getClass(), excludeColumns);
    }

    public LambdaQueryWrapper<T> lambda() {
        return new LambdaQueryWrapper<Object>(this.entity, this.paramNameSeq, this.paramNameValuePairs, this.expression);
    }

    @Override
    protected String columnToString(String column) {
        return column;
    }

    @Override
    protected QueryWrapper<T> instance(AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs) {
        return new QueryWrapper<Object>(this.entity, this.sqlSelect, paramNameSeq, paramNameValuePairs, new MergeSegments());
    }
}

