/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.metadata;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.lang.reflect.Field;

public class TableFieldInfo {
    private boolean related = false;
    private String column;
    private String property;
    private String el;
    private Class<?> propertyType;
    private FieldStrategy fieldStrategy = FieldStrategy.NOT_NULL;
    private String logicDeleteValue;
    private String logicNotDeleteValue;
    private String update;
    private String condition = "%s=#{%s}";
    private FieldFill fieldFill = FieldFill.DEFAULT;
    private Class<?> parentClass;

    public TableFieldInfo(boolean underCamel, GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, String column, String el, Field field, TableField tableField, Class<?> parentClass) {
        this.property = field.getName();
        this.propertyType = field.getType();
        if (StringUtils.isEmpty(tableField.value())) {
            if (dbConfig.isColumnUnderline()) {
                column = StringUtils.camelToUnderline(column);
            }
            if (!underCamel) {
                this.related = true;
            }
        } else if (!column.equals(this.property)) {
            this.related = true;
        }
        this.setColumn(dbConfig, column);
        this.el = el;
        this.fieldStrategy = dbConfig.getFieldStrategy() != tableField.strategy() ? tableField.strategy() : dbConfig.getFieldStrategy();
        tableInfo.setLogicDelete(this.initLogicDelete(dbConfig, field));
        this.update = tableField.update();
        if (StringUtils.isNotEmpty(tableField.condition())) {
            this.condition = tableField.condition();
        } else {
            this.setCondition(dbConfig);
        }
        this.fieldFill = tableField.fill();
        this.parentClass = parentClass;
    }

    public TableFieldInfo(boolean underCamel, GlobalConfig.DbConfig dbConfig, TableInfo tableInfo, Field field, Class<?> parentClass) {
        if (dbConfig.isColumnUnderline()) {
            this.setColumn(dbConfig, StringUtils.camelToUnderline(field.getName()));
            if (!underCamel) {
                this.related = true;
            }
        } else {
            this.setColumn(dbConfig, field.getName());
        }
        this.property = field.getName();
        this.el = field.getName();
        this.fieldStrategy = dbConfig.getFieldStrategy();
        this.propertyType = field.getType();
        this.setCondition(dbConfig);
        this.parentClass = parentClass;
        tableInfo.setLogicDelete(this.initLogicDelete(dbConfig, field));
    }

    private boolean initLogicDelete(GlobalConfig.DbConfig dbConfig, Field field) {
        if (null == dbConfig.getLogicDeleteValue()) {
            return false;
        }
        TableLogic tableLogic = field.getAnnotation(TableLogic.class);
        if (null != tableLogic) {
            this.logicNotDeleteValue = StringUtils.isNotEmpty(tableLogic.value()) ? tableLogic.value() : dbConfig.getLogicNotDeleteValue();
            this.logicDeleteValue = StringUtils.isNotEmpty(tableLogic.delval()) ? tableLogic.delval() : dbConfig.getLogicDeleteValue();
            return true;
        }
        return false;
    }

    public boolean isRelated() {
        return this.related;
    }

    public void setRelated(boolean related) {
        this.related = related;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(GlobalConfig.DbConfig dbConfig, String column) {
        String temp = dbConfig.getReservedWordsHandler().convert(dbConfig.getDbType(), column);
        if (dbConfig.isCapitalMode() && !this.isRelated()) {
            temp = temp.toUpperCase();
        }
        this.column = temp;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getEl() {
        return this.el;
    }

    public void setEl(String el) {
        this.el = el;
    }

    public FieldStrategy getFieldStrategy() {
        return this.fieldStrategy;
    }

    public void setFieldStrategy(FieldStrategy fieldStrategy) {
        this.fieldStrategy = fieldStrategy;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public boolean isLogicDelete() {
        return StringUtils.isNotEmpty(this.logicDeleteValue);
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public void setLogicDeleteValue(String logicDeleteValue) {
        this.logicDeleteValue = logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public void setLogicNotDeleteValue(String logicNotDeleteValue) {
        this.logicNotDeleteValue = logicNotDeleteValue;
    }

    public String getUpdate() {
        return this.update;
    }

    public void setUpdate(String update) {
        this.update = update;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(GlobalConfig.DbConfig dbConfig) {
        if ((null == this.condition || "%s=#{%s}".equals(this.condition)) && dbConfig.isColumnLike() && StringUtils.isCharSequence(this.propertyType).booleanValue()) {
            this.condition = dbConfig.getDbType().getLike();
        }
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public FieldFill getFieldFill() {
        return this.fieldFill;
    }

    public void setFieldFill(FieldFill fieldFill) {
        this.fieldFill = fieldFill;
    }

    public Class<?> getParentClass() {
        return this.parentClass;
    }

    public void setParentClass(Class<?> parentClass) {
        this.parentClass = parentClass;
    }
}

