/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import java.util.Collection;
import java.util.Map;

public final class Assert {
    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw ExceptionUtils.mpe(message);
        }
    }

    public static void isFalse(boolean expression, String message) {
        Assert.isTrue(!expression, message);
    }

    public static void isNull(Object object, String message) {
        Assert.isTrue(object == null, message);
    }

    public static void notNull(Object object, String message) {
        Assert.isTrue(object != null, message);
    }

    public static void notEmpty(Collection<?> collection, String message) {
        Assert.isTrue(CollectionUtils.isNotEmpty(collection), message);
    }

    public static void notEmpty(Map<?, ?> map, String message) {
        Assert.isTrue(CollectionUtils.isNotEmpty(map), message);
    }

    public static void notEmpty(Object[] array, String message) {
        Assert.isTrue(ArrayUtils.isNotEmpty(array), message);
    }
}

