/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.toolkit;

import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Objects;

public class EnumUtils {
    public static <E extends Enum<?>> E valueOf(Class<E> enumClass, Object value, Method method) {
        Enum[] es;
        for (Enum e : es = (Enum[])enumClass.getEnumConstants()) {
            Object evalue;
            try {
                method.setAccessible(true);
                evalue = method.invoke((Object)e, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e1) {
                throw ExceptionUtils.mpe("Error: NoSuchMethod in %s.  Cause:", e, enumClass.getName());
            }
            if (value instanceof Number && evalue instanceof Number && new BigDecimal(String.valueOf(value)).compareTo(new BigDecimal(String.valueOf(evalue))) == 0) {
                return (E)e;
            }
            if (!Objects.equals(evalue, value)) continue;
            return (E)e;
        }
        return null;
    }
}

