/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core.conditions;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.ColumnCache;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ibatis.reflection.property.PropertyNamer;

public abstract class AbstractLambdaWrapper<T, Children extends AbstractLambdaWrapper<T, Children>>
extends AbstractWrapper<T, SFunction<T, ?>, Children> {
    private Map<String, ColumnCache> columnMap = null;
    private boolean initColumnMap = false;

    protected String columnsToString(SFunction<T, ?> ... columns) {
        return this.columnsToString(true, columns);
    }

    protected String columnsToString(boolean onlyColumn, SFunction<T, ?> ... columns) {
        return Arrays.stream(columns).map(i -> this.columnToString((SFunction<T, ?>)i, onlyColumn)).collect(Collectors.joining(","));
    }

    @Override
    protected String columnToString(SFunction<T, ?> column) {
        return this.columnToString(column, true);
    }

    protected String columnToString(SFunction<T, ?> column, boolean onlyColumn) {
        return this.getColumn(LambdaUtils.resolve(column), onlyColumn);
    }

    private String getColumn(SerializedLambda lambda, boolean onlyColumn) {
        Class<?> aClass = lambda.getInstantiatedType();
        this.tryInitCache(aClass);
        String fieldName = PropertyNamer.methodToProperty((String)lambda.getImplMethodName());
        ColumnCache columnCache = this.getColumnCache(fieldName, aClass);
        return onlyColumn ? columnCache.getColumn() : columnCache.getColumnSelect();
    }

    private void tryInitCache(Class<?> lambdaClass) {
        if (!this.initColumnMap) {
            Class entityClass = this.getEntityClass();
            if (entityClass != null) {
                lambdaClass = entityClass;
            }
            this.columnMap = LambdaUtils.getColumnMap(lambdaClass);
            this.initColumnMap = true;
        }
        Assert.notNull(this.columnMap, "can not find lambda cache for this entity [%s]", lambdaClass.getName());
    }

    private ColumnCache getColumnCache(String fieldName, Class<?> lambdaClass) {
        ColumnCache columnCache = this.columnMap.get(LambdaUtils.formatKey(fieldName));
        Assert.notNull(columnCache, "can not find lambda cache for this property [%s] of entity [%s]", fieldName, lambdaClass.getName());
        return columnCache;
    }
}

