/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.dts.config;

import com.baomidou.mybatisplus.dts.listener.RabbitRmtListener;
import com.baomidou.mybatisplus.dts.sender.RabbitRmtSender;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.TopicExchange;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.transaction.RabbitTransactionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={EnableRabbit.class})
public class RabbitConfiguration {
    @Autowired
    protected RabbitTemplate rabbitTemplate;
    @Autowired
    protected RabbitAdmin rabbitAdmin;

    @Bean
    public RabbitRmtSender rmtSender() {
        return new RabbitRmtSender();
    }

    @Bean
    public RabbitRmtListener rabbitRmtListener() {
        return new RabbitRmtListener();
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.jdbc.datasource.DataSourceTransactionManager"})
    public RabbitTransactionManager rabbitTransactionManager(ConnectionFactory connectionFactory) {
        return new RabbitTransactionManager(connectionFactory);
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.amqp.rabbit.core.RabbitAdmin"})
    public RabbitAdmin rabbitAdmin(ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @PostConstruct
    protected void init() {
        this.rabbitTemplate.setChannelTransacted(true);
        this.rabbitAdmin.declareExchange((Exchange)new DirectExchange("dts-rmt-deadletter-exchange", true, false));
        this.rabbitAdmin.declareQueue(new Queue("dts-rmt-deadletter-queue", true, false, false, null));
        this.rabbitAdmin.declareBinding(new Binding("dts-rmt-deadletter-queue", Binding.DestinationType.QUEUE, "dts-rmt-deadletter-exchange", "dts-rmt-deadletter-routingkey", null));
        this.rabbitAdmin.declareExchange((Exchange)new TopicExchange("dts-rmt-exchange", true, false));
        HashMap<String, String> args = new HashMap<String, String>(2);
        args.put("x-dead-letter-exchange", "dts-rmt-deadletter-exchange");
        args.put("x-dead-letter-routing-key", "dts-rmt-deadletter-routingkey");
        this.rabbitAdmin.declareQueue(new Queue("dts-rmt-queue", true, false, true, args));
        this.rabbitAdmin.declareBinding(new Binding("dts-rmt-queue", Binding.DestinationType.QUEUE, "dts-rmt-exchange", "dts-rmt-routingkey", null));
    }
}

