/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.dts.listener;

import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.dts.DtsMeta;
import com.baomidou.mybatisplus.dts.listener.IDtsListener;
import com.baomidou.mybatisplus.dts.parser.IDtsParser;
import java.util.List;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@RabbitListener(queues={"dts-rmt-queue"})
public class RabbitRmtListener {
    @Autowired
    private IDtsParser dtsParser;
    @Autowired
    private List<IDtsListener> dtsListenerList;

    @RabbitHandler
    @Transactional(rollbackFor={Exception.class})
    public void receive(String event) {
        try {
            DtsMeta dtsMeta = this.dtsParser.readValue(event, DtsMeta.class);
            this.dtsListenerList.forEach(d -> d.process(dtsMeta));
        }
        catch (Exception e) {
            ExceptionUtils.mpe((String)"rmt parser error, event: %s", (Throwable)e, (Object[])new Object[]{event});
        }
    }
}

