/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.MybatisDefaultParameterHandler;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.handlers.AbstractSqlParserHandler;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectFactory;
import com.baomidou.mybatisplus.extension.toolkit.JdbcUtils;
import com.baomidou.mybatisplus.extension.toolkit.SqlParserUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PaginationInterceptor
extends AbstractSqlParserHandler
implements Interceptor {
    private ISqlParser sqlParser;
    private boolean overflow = false;
    private String dialectType;
    private String dialectClazz;

    public static String concatOrderBy(String originalSql, IPage page, boolean orderBy) {
        if (orderBy && (ArrayUtils.isNotEmpty((Object[])page.ascs()) || ArrayUtils.isNotEmpty((Object[])page.descs()))) {
            StringBuilder buildSql = new StringBuilder(originalSql);
            String ascStr = PaginationInterceptor.concatOrderBuilder(page.ascs(), " ASC");
            String descStr = PaginationInterceptor.concatOrderBuilder(page.descs(), " DESC");
            if (StringUtils.isNotEmpty((CharSequence)ascStr) && StringUtils.isNotEmpty((CharSequence)descStr)) {
                ascStr = ascStr + ", ";
            }
            if (StringUtils.isNotEmpty((CharSequence)ascStr) || StringUtils.isNotEmpty((CharSequence)descStr)) {
                buildSql.append(" ORDER BY ").append(ascStr).append(descStr);
            }
            return buildSql.toString();
        }
        return originalSql;
    }

    private static String concatOrderBuilder(String[] columns, String orderWord) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            return Arrays.stream(columns).filter(StringUtils::isNotEmpty).collect(Collectors.joining(",", "", orderWord));
        }
        return "";
    }

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)PluginUtils.realTarget((Object)invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        this.sqlParser(metaObject);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        if (!SqlCommandType.SELECT.equals((Object)mappedStatement.getSqlCommandType())) {
            return invocation.proceed();
        }
        BoundSql boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        Object paramObj = boundSql.getParameterObject();
        IPage page = null;
        if (paramObj instanceof IPage) {
            page = (IPage)paramObj;
        } else if (paramObj instanceof Map) {
            for (Object arg : ((Map)paramObj).values()) {
                if (!(arg instanceof IPage)) continue;
                page = (IPage)arg;
                break;
            }
        }
        if (null == page || page.getSize() < 0L) {
            return invocation.proceed();
        }
        String originalSql = boundSql.getSql();
        Connection connection = (Connection)invocation.getArgs()[0];
        DbType dbType = StringUtils.isNotEmpty((CharSequence)this.dialectType) ? DbType.getDbType((String)this.dialectType) : JdbcUtils.getDbType(connection.getMetaData().getURL());
        boolean orderBy = true;
        if (page.getTotal() == 0L) {
            SqlInfo sqlInfo = SqlParserUtils.getOptimizeCountSql(page.optimizeCountSql(), this.sqlParser, originalSql);
            orderBy = sqlInfo.isOrderBy();
            this.queryTotal(this.overflow, sqlInfo.getSql(), mappedStatement, boundSql, page, connection);
            if (page.getTotal() <= 0L) {
                return invocation.proceed();
            }
        }
        String buildSql = PaginationInterceptor.concatOrderBy(originalSql, page, orderBy);
        originalSql = DialectFactory.buildPaginationSql(page, buildSql, dbType, this.dialectClazz);
        metaObject.setValue("delegate.boundSql.sql", (Object)originalSql);
        metaObject.setValue("delegate.rowBounds.offset", (Object)0);
        metaObject.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
        return invocation.proceed();
    }

    protected void queryTotal(boolean overflowCurrent, String sql, MappedStatement mappedStatement, BoundSql boundSql, IPage page, Connection connection) {
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            MybatisDefaultParameterHandler parameterHandler = new MybatisDefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), boundSql);
            parameterHandler.setParameters(statement);
            long total = 0L;
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    total = resultSet.getLong(1);
                }
            }
            page.setTotal(total);
            long pages = page.getPages();
            if (overflowCurrent && page.getCurrent() > pages) {
                page.setCurrent(1L);
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.mpe((String)"Error: Method queryTotal execution error.", (Throwable)e);
        }
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties prop) {
        String dialectType = prop.getProperty("dialectType");
        String dialectClazz = prop.getProperty("dialectClazz");
        if (StringUtils.isNotEmpty((CharSequence)dialectType)) {
            this.dialectType = dialectType;
        }
        if (StringUtils.isNotEmpty((CharSequence)dialectClazz)) {
            this.dialectClazz = dialectClazz;
        }
    }

    public PaginationInterceptor setSqlParser(ISqlParser sqlParser) {
        this.sqlParser = sqlParser;
        return this;
    }

    public PaginationInterceptor setOverflow(boolean overflow) {
        this.overflow = overflow;
        return this;
    }

    public PaginationInterceptor setDialectType(String dialectType) {
        this.dialectType = dialectType;
        return this;
    }

    public PaginationInterceptor setDialectClazz(String dialectClazz) {
        this.dialectClazz = dialectClazz;
        return this;
    }
}

