/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.handlers;

import com.baomidou.mybatisplus.core.parser.ISqlParser;
import com.baomidou.mybatisplus.core.parser.ISqlParserFilter;
import com.baomidou.mybatisplus.core.parser.SqlInfo;
import com.baomidou.mybatisplus.core.parser.SqlParserHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.List;
import org.apache.ibatis.reflection.MetaObject;

public abstract class AbstractSqlParserHandler {
    private List<ISqlParser> sqlParserList;
    private ISqlParserFilter sqlParserFilter;

    protected void sqlParser(MetaObject metaObject) {
        if (null != metaObject) {
            if (null != this.sqlParserFilter && this.sqlParserFilter.doFilter(metaObject)) {
                return;
            }
            if (CollectionUtils.isNotEmpty(this.sqlParserList)) {
                if (SqlParserHelper.getSqlParserInfo((MetaObject)metaObject)) {
                    return;
                }
                int flag = 0;
                String originalSql = (String)metaObject.getValue("delegate.boundSql.sql");
                for (ISqlParser sqlParser : this.sqlParserList) {
                    SqlInfo sqlInfo = sqlParser.parser(metaObject, originalSql);
                    if (null == sqlInfo) continue;
                    originalSql = sqlInfo.getSql();
                    ++flag;
                }
                if (flag >= 1) {
                    metaObject.setValue("delegate.boundSql.sql", (Object)originalSql);
                }
            }
        }
    }

    public List<ISqlParser> getSqlParserList() {
        return this.sqlParserList;
    }

    public ISqlParserFilter getSqlParserFilter() {
        return this.sqlParserFilter;
    }

    public AbstractSqlParserHandler setSqlParserList(List<ISqlParser> sqlParserList) {
        this.sqlParserList = sqlParserList;
        return this;
    }

    public AbstractSqlParserHandler setSqlParserFilter(ISqlParserFilter sqlParserFilter) {
        this.sqlParserFilter = sqlParserFilter;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSqlParserHandler)) {
            return false;
        }
        AbstractSqlParserHandler other = (AbstractSqlParserHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ISqlParser> this$sqlParserList = this.getSqlParserList();
        List<ISqlParser> other$sqlParserList = other.getSqlParserList();
        if (this$sqlParserList == null ? other$sqlParserList != null : !((Object)this$sqlParserList).equals(other$sqlParserList)) {
            return false;
        }
        ISqlParserFilter this$sqlParserFilter = this.getSqlParserFilter();
        ISqlParserFilter other$sqlParserFilter = other.getSqlParserFilter();
        return !(this$sqlParserFilter == null ? other$sqlParserFilter != null : !this$sqlParserFilter.equals(other$sqlParserFilter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractSqlParserHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ISqlParser> $sqlParserList = this.getSqlParserList();
        result = result * 59 + ($sqlParserList == null ? 43 : ((Object)$sqlParserList).hashCode());
        ISqlParserFilter $sqlParserFilter = this.getSqlParserFilter();
        result = result * 59 + ($sqlParserFilter == null ? 43 : $sqlParserFilter.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractSqlParserHandler(sqlParserList=" + this.getSqlParserList() + ", sqlParserFilter=" + this.getSqlParserFilter() + ")";
    }
}

