/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.pagination;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.DialectModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.DB2Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.DmDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.H2Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.HSQLDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.IDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.MariaDBDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.MySqlDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.OracleDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.PostgreDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLServer2005Dialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLServerDialect;
import com.baomidou.mybatisplus.extension.plugins.pagination.dialects.SQLiteDialect;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DialectFactory {
    private static final Map<String, IDialect> DIALECT_CACHE = new ConcurrentHashMap<String, IDialect>();

    public static DialectModel buildPaginationSql(IPage page, String buildSql, DbType dbType, String dialectClazz) {
        return DialectFactory.getDialect(dbType, dialectClazz).buildPaginationSql(buildSql, page.offset(), page.getSize());
    }

    /*
     * Unable to fully structure code
     */
    private static IDialect getDialect(DbType dbType, String dialectClazz) {
        dialect = DialectFactory.DIALECT_CACHE.get(dbType.getDb());
        if (null == dialect) {
            if (StringUtils.isNotEmpty((CharSequence)dialectClazz)) {
                dialect = DialectFactory.DIALECT_CACHE.get(dialectClazz);
                if (null != dialect) {
                    return dialect;
                }
                try {
                    clazz = Class.forName(dialectClazz);
                    if (!IDialect.class.isAssignableFrom(clazz)) ** GOTO lbl21
                    dialect = (IDialect)clazz.newInstance();
                    DialectFactory.DIALECT_CACHE.put(dialectClazz, dialect);
                }
                catch (ClassNotFoundException e) {
                    throw ExceptionUtils.mpe((String)"Class : %s is not found", (Object[])new Object[]{dialectClazz});
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw ExceptionUtils.mpe((String)"Class : %s can not be instance", (Object[])new Object[]{dialectClazz});
                }
            } else {
                dialect = DialectFactory.getDialectByDbType(dbType);
                DialectFactory.DIALECT_CACHE.put(dbType.getDb(), dialect);
            }
lbl21:
            // 3 sources

            Assert.notNull((Object)dialect, (String)"The value of the dialect property in mybatis configuration.xml is not defined.", (Object[])new Object[0]);
        }
        return dialect;
    }

    private static IDialect getDialectByDbType(DbType dbType) {
        switch (dbType) {
            case MYSQL: {
                return new MySqlDialect();
            }
            case MARIADB: {
                return new MariaDBDialect();
            }
            case ORACLE: {
                return new OracleDialect();
            }
            case DB2: {
                return new DB2Dialect();
            }
            case H2: {
                return new H2Dialect();
            }
            case SQL_SERVER: {
                return new SQLServerDialect();
            }
            case SQL_SERVER2005: {
                return new SQLServer2005Dialect();
            }
            case POSTGRE_SQL: {
                return new PostgreDialect();
            }
            case HSQL: {
                return new HSQLDialect();
            }
            case SQLITE: {
                return new SQLiteDialect();
            }
            case DM: {
                return new DmDialect();
            }
        }
        throw ExceptionUtils.mpe((String)"The Database's IDialect Not Supported!", (Object[])new Object[0]);
    }
}

