/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.ddl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.ddl.DdlHelper;
import com.baomidou.mybatisplus.extension.ddl.history.IDdlGenerator;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;

public class DdlScript {
    private final DataSource dataSource;
    private final IDdlGenerator ddlGenerator;
    private final boolean autoCommit;

    public DdlScript(DataSource dataSource) {
        this(dataSource, null);
    }

    public DdlScript(DataSource dataSource, IDdlGenerator ddlGenerator) {
        this(dataSource, ddlGenerator, false);
    }

    public DdlScript(DataSource dataSource, IDdlGenerator ddlGenerator, boolean autoCommit) {
        this.dataSource = dataSource;
        this.ddlGenerator = ddlGenerator;
        this.autoCommit = autoCommit;
    }

    public void run(List<String> sqlFiles) {
        this.run(sqlFiles, this.autoCommit);
    }

    public void run(List<String> sqlFiles, boolean autoCommit) {
        DdlHelper.runScript(this.ddlGenerator, this.dataSource, sqlFiles, autoCommit);
    }

    public void run(String sqlScript) throws Exception {
        this.run(sqlScript, null);
    }

    public void run(String sqlScript, String delimiter) throws Exception {
        this.run(new StringReader(sqlScript), this.autoCommit, delimiter);
    }

    public void run(Reader reader) throws Exception {
        this.run(reader, this.autoCommit, null);
    }

    public void run(Reader reader, boolean autoCommit) throws Exception {
        this.run(reader, autoCommit, null);
    }

    public void run(Reader reader, boolean autoCommit, String delimiter) throws Exception {
        this.run(this.dataSource.getConnection(), reader, autoCommit, delimiter);
    }

    public void run(Connection connection, Reader reader, boolean autoCommit, String delimiter) {
        ScriptRunner scriptRunner = DdlHelper.getScriptRunner(connection, autoCommit);
        if (StringUtils.isNotBlank((CharSequence)delimiter)) {
            scriptRunner.setDelimiter(delimiter);
        }
        scriptRunner.runScript(reader);
    }

    public boolean execute(String driverClassName, String url, String user, String password, String sql, Consumer<String> exceptionConsumer) {
        return this.execute(driverClassName, url, user, password, sql, null, exceptionConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String driverClassName, String url, String user, String password, String sql, String delimiter, Consumer<String> exceptionConsumer) {
        Connection connection = null;
        try {
            Class.forName(driverClassName);
            connection = DriverManager.getConnection(url, user, password);
            this.run(connection, new StringReader(sql), this.autoCommit, delimiter);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (null != connection) {
                try {
                    connection.rollback();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
            exceptionConsumer.accept(e.getMessage());
        }
        finally {
            if (null != connection) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }
}

