/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.baomidou.mybatisplus.generator.config.IKeyWordsHandler;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableFill;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConfigBuilder {
    private final TemplateConfig template;
    private final DataSourceConfig dataSourceConfig;
    private Connection connection;
    @Deprecated
    private IDbQuery dbQuery;
    @Deprecated
    private DbType dbType;
    private String superEntityClass;
    private String superMapperClass;
    private String superServiceClass;
    private String superServiceImplClass;
    private String superControllerClass;
    private List<TableInfo> tableInfoList;
    private Map<String, String> packageInfo;
    private Map<String, String> pathInfo;
    private StrategyConfig strategyConfig;
    private GlobalConfig globalConfig;
    private InjectionConfig injectionConfig;
    @Deprecated
    private boolean commentSupported;
    private static final Pattern REGX = Pattern.compile("[~!/@#$%^&*()-_=+\\\\|[{}];:'\",<.>?]+");

    public ConfigBuilder(PackageConfig packageConfig, DataSourceConfig dataSourceConfig, StrategyConfig strategyConfig, TemplateConfig template, GlobalConfig globalConfig) {
        this.globalConfig = Optional.ofNullable(globalConfig).orElseGet(GlobalConfig::new);
        this.template = Optional.ofNullable(template).orElseGet(TemplateConfig::new);
        if (null == packageConfig) {
            this.handlerPackage(this.template, this.globalConfig.getOutputDir(), new PackageConfig());
        } else {
            this.handlerPackage(this.template, this.globalConfig.getOutputDir(), packageConfig);
        }
        this.dataSourceConfig = dataSourceConfig;
        this.handlerDataSource(dataSourceConfig);
        this.strategyConfig = Optional.ofNullable(strategyConfig).orElseGet(StrategyConfig::new);
        this.commentSupported = !dataSourceConfig.getDbType().equals((Object)DbType.SQLITE);
        this.handlerStrategy(this.strategyConfig);
    }

    public Map<String, String> getPackageInfo() {
        return this.packageInfo;
    }

    public Map<String, String> getPathInfo() {
        return this.pathInfo;
    }

    public String getSuperEntityClass() {
        return this.superEntityClass;
    }

    public String getSuperMapperClass() {
        return this.superMapperClass;
    }

    public String getSuperServiceClass() {
        return this.superServiceClass;
    }

    public String getSuperServiceImplClass() {
        return this.superServiceImplClass;
    }

    public String getSuperControllerClass() {
        return this.superControllerClass;
    }

    public List<TableInfo> getTableInfoList() {
        return this.tableInfoList;
    }

    public ConfigBuilder setTableInfoList(List<TableInfo> tableInfoList) {
        this.tableInfoList = tableInfoList;
        return this;
    }

    public TemplateConfig getTemplate() {
        return this.template;
    }

    private void handlerPackage(TemplateConfig template, String outputDir, PackageConfig config) {
        this.packageInfo = CollectionUtils.newHashMapWithExpectedSize((int)7);
        this.packageInfo.put("ModuleName", config.getModuleName());
        this.packageInfo.put("Entity", this.joinPackage(config.getParent(), config.getEntity()));
        this.packageInfo.put("Mapper", this.joinPackage(config.getParent(), config.getMapper()));
        this.packageInfo.put("Xml", this.joinPackage(config.getParent(), config.getXml()));
        this.packageInfo.put("Service", this.joinPackage(config.getParent(), config.getService()));
        this.packageInfo.put("ServiceImpl", this.joinPackage(config.getParent(), config.getServiceImpl()));
        this.packageInfo.put("Controller", this.joinPackage(config.getParent(), config.getController()));
        Map<String, String> configPathInfo = config.getPathInfo();
        if (null != configPathInfo) {
            this.pathInfo = configPathInfo;
        } else {
            this.pathInfo = CollectionUtils.newHashMapWithExpectedSize((int)6);
            this.setPathInfo(this.pathInfo, template.getEntity(this.getGlobalConfig().isKotlin()), outputDir, "entity_path", "Entity");
            this.setPathInfo(this.pathInfo, template.getMapper(), outputDir, "mapper_path", "Mapper");
            this.setPathInfo(this.pathInfo, template.getXml(), outputDir, "xml_path", "Xml");
            this.setPathInfo(this.pathInfo, template.getService(), outputDir, "service_path", "Service");
            this.setPathInfo(this.pathInfo, template.getServiceImpl(), outputDir, "service_impl_path", "ServiceImpl");
            this.setPathInfo(this.pathInfo, template.getController(), outputDir, "controller_path", "Controller");
        }
    }

    private void setPathInfo(Map<String, String> pathInfo, String template, String outputDir, String path, String module) {
        if (StringUtils.isNotBlank((CharSequence)template)) {
            pathInfo.put(path, this.joinPath(outputDir, this.packageInfo.get(module)));
        }
    }

    private void handlerDataSource(DataSourceConfig config) {
        this.connection = config.getConn();
        this.dbType = config.getDbType();
        this.dbQuery = config.getDbQuery();
    }

    private void handlerStrategy(StrategyConfig config) {
        this.processTypes(config);
        this.tableInfoList = this.getTablesInfo(config);
    }

    private void processTypes(StrategyConfig config) {
        this.superServiceClass = ConfigBuilder.getValueOrDefault(config.getSuperServiceClass(), "com.baomidou.mybatisplus.extension.service.IService");
        this.superServiceImplClass = ConfigBuilder.getValueOrDefault(config.getSuperServiceImplClass(), "com.baomidou.mybatisplus.extension.service.impl.ServiceImpl");
        this.superMapperClass = ConfigBuilder.getValueOrDefault(config.getSuperMapperClass(), "com.baomidou.mybatisplus.core.mapper.BaseMapper");
        this.superEntityClass = config.getSuperEntityClass();
        this.superControllerClass = config.getSuperControllerClass();
    }

    private static String getValueOrDefault(String value, String defaultValue) {
        return StringUtils.isBlank((CharSequence)value) ? defaultValue : value;
    }

    @Deprecated
    private List<TableInfo> processTable(List<TableInfo> tableList, NamingStrategy strategy, StrategyConfig config) {
        return this.processTable(tableList, config);
    }

    private List<TableInfo> processTable(List<TableInfo> tableList, StrategyConfig config) {
        String[] tablePrefix = config.getTablePrefix();
        for (TableInfo tableInfo : tableList) {
            INameConvert nameConvert = this.strategyConfig.getNameConvert();
            String entityName = null != nameConvert ? nameConvert.entityNameConvert(tableInfo) : NamingStrategy.capitalFirst(this.processName(tableInfo.getName(), config.getNaming(), tablePrefix));
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getEntityName())) {
                tableInfo.setConvert(true);
                tableInfo.setEntityName(String.format(this.globalConfig.getEntityName(), entityName));
            } else {
                tableInfo.setEntityName(this.strategyConfig, entityName);
            }
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getMapperName())) {
                tableInfo.setMapperName(String.format(this.globalConfig.getMapperName(), entityName));
            } else {
                tableInfo.setMapperName(entityName + "Mapper");
            }
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getXmlName())) {
                tableInfo.setXmlName(String.format(this.globalConfig.getXmlName(), entityName));
            } else {
                tableInfo.setXmlName(entityName + "Mapper");
            }
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getServiceName())) {
                tableInfo.setServiceName(String.format(this.globalConfig.getServiceName(), entityName));
            } else {
                tableInfo.setServiceName("I" + entityName + "Service");
            }
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getServiceImplName())) {
                tableInfo.setServiceImplName(String.format(this.globalConfig.getServiceImplName(), entityName));
            } else {
                tableInfo.setServiceImplName(entityName + "ServiceImpl");
            }
            if (StringUtils.isNotBlank((CharSequence)this.globalConfig.getControllerName())) {
                tableInfo.setControllerName(String.format(this.globalConfig.getControllerName(), entityName));
            } else {
                tableInfo.setControllerName(entityName + "Controller");
            }
            this.checkImportPackages(tableInfo);
        }
        return tableList;
    }

    private void checkImportPackages(TableInfo tableInfo) {
        if (StringUtils.isNotBlank((CharSequence)this.strategyConfig.getSuperEntityClass())) {
            tableInfo.getImportPackages().add(this.strategyConfig.getSuperEntityClass());
        } else if (this.globalConfig.isActiveRecord()) {
            tableInfo.getImportPackages().add(Model.class.getCanonicalName());
        }
        if (null != this.globalConfig.getIdType() && tableInfo.isHavePrimaryKey()) {
            tableInfo.getImportPackages().add(IdType.class.getCanonicalName());
            tableInfo.getImportPackages().add(TableId.class.getCanonicalName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.strategyConfig.getVersionFieldName()) && CollectionUtils.isNotEmpty(tableInfo.getFields())) {
            tableInfo.getFields().forEach(f -> {
                if (this.strategyConfig.getVersionFieldName().equals(f.getName())) {
                    tableInfo.getImportPackages().add(Version.class.getCanonicalName());
                }
            });
        }
    }

    private List<TableInfo> getTablesInfo(StrategyConfig config) {
        boolean isExclude;
        boolean isInclude = null != config.getInclude() && config.getInclude().length > 0;
        boolean bl = isExclude = null != config.getExclude() && config.getExclude().length > 0;
        if (isInclude && isExclude) {
            throw new RuntimeException("<strategy> \u6807\u7b7e\u4e2d <include> \u4e0e <exclude> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
        if (config.getNotLikeTable() != null && config.getLikeTable() != null) {
            throw new RuntimeException("<strategy> \u6807\u7b7e\u4e2d <likeTable> \u4e0e <notLikeTable> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        ArrayList<TableInfo> includeTableList = new ArrayList<TableInfo>();
        ArrayList<TableInfo> excludeTableList = new ArrayList<TableInfo>();
        HashSet<String> notExistTables = new HashSet<String>();
        DbType dbType = this.dataSourceConfig.getDbType();
        IDbQuery dbQuery = this.dataSourceConfig.getDbQuery();
        try {
            String schema;
            String tablesSql = this.dataSourceConfig.getDbQuery().tablesSql();
            if (DbType.POSTGRE_SQL == dbType) {
                schema = this.dataSourceConfig.getSchemaName();
                if (schema == null) {
                    schema = "public";
                    this.dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
            } else if (DbType.KINGBASE_ES == dbType) {
                schema = this.dataSourceConfig.getSchemaName();
                if (schema == null) {
                    schema = "PUBLIC";
                    this.dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
            } else if (DbType.DB2 == dbType) {
                schema = this.dataSourceConfig.getSchemaName();
                if (schema == null) {
                    schema = "current schema";
                    this.dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
            } else if (DbType.ORACLE == dbType) {
                schema = this.dataSourceConfig.getSchemaName();
                if (schema == null) {
                    schema = this.dataSourceConfig.getUsername().toUpperCase();
                    this.dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
            }
            StringBuilder sql = new StringBuilder(tablesSql);
            if (config.isEnableSqlFilter()) {
                if (config.getLikeTable() != null) {
                    sql.append(" AND ").append(dbQuery.tableName()).append(" LIKE '").append(config.getLikeTable().getValue()).append("'");
                } else if (config.getNotLikeTable() != null) {
                    sql.append(" AND ").append(dbQuery.tableName()).append(" NOT LIKE '").append(config.getNotLikeTable().getValue()).append("'");
                }
                if (isInclude) {
                    sql.append(" AND ").append(dbQuery.tableName()).append(" IN (").append(Arrays.stream(config.getInclude()).map(tb -> "'" + tb + "'").collect(Collectors.joining(","))).append(")");
                } else if (isExclude) {
                    sql.append(" AND ").append(dbQuery.tableName()).append(" NOT IN (").append(Arrays.stream(config.getExclude()).map(tb -> "'" + tb + "'").collect(Collectors.joining(","))).append(")");
                }
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(sql.toString());
                 ResultSet results = preparedStatement.executeQuery();){
                while (results.next()) {
                    String tableName = results.getString(dbQuery.tableName());
                    if (StringUtils.isBlank((CharSequence)tableName)) {
                        System.err.println("\u5f53\u524d\u6570\u636e\u5e93\u4e3a\u7a7a\uff01\uff01\uff01");
                        continue;
                    }
                    TableInfo tableInfo = new TableInfo();
                    tableInfo.setName(tableName);
                    String commentColumn = dbQuery.tableComment();
                    if (StringUtils.isNotBlank((CharSequence)commentColumn)) {
                        String tableComment = results.getString(commentColumn);
                        if (config.isSkipView() && "VIEW".equals(tableComment)) continue;
                        tableInfo.setComment(this.formatComment(tableComment));
                    }
                    if (isInclude) {
                        for (String includeTable : config.getInclude()) {
                            if (this.tableNameMatches(includeTable, tableName)) {
                                includeTableList.add(tableInfo);
                                continue;
                            }
                            if (REGX.matcher(includeTable).find()) continue;
                            notExistTables.add(includeTable);
                        }
                    } else if (isExclude) {
                        for (String excludeTable : config.getExclude()) {
                            if (this.tableNameMatches(excludeTable, tableName)) {
                                excludeTableList.add(tableInfo);
                                continue;
                            }
                            if (REGX.matcher(excludeTable).find()) continue;
                            notExistTables.add(excludeTable);
                        }
                    }
                    tableList.add(tableInfo);
                }
            }
            for (TableInfo tabInfo : tableList) {
                notExistTables.remove(tabInfo.getName());
            }
            if (notExistTables.size() > 0) {
                System.err.println("\u8868 " + notExistTables + " \u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
            if (isExclude) {
                tableList.removeAll(excludeTableList);
                includeTableList = tableList;
            }
            if (!isInclude && !isExclude) {
                includeTableList = tableList;
            }
            includeTableList.forEach(ti -> this.convertTableFields((TableInfo)ti, config));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.processTable(includeTableList, config);
    }

    private boolean tableNameMatches(String setTableName, String dbTableName) {
        return setTableName.equalsIgnoreCase(dbTableName) || StringUtils.matches((String)setTableName, (String)dbTableName);
    }

    private TableInfo convertTableFields(TableInfo tableInfo, StrategyConfig config) {
        boolean haveId = false;
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        ArrayList<TableField> commonFieldList = new ArrayList<TableField>();
        DbType dbType = this.dataSourceConfig.getDbType();
        IDbQuery dbQuery = this.dataSourceConfig.getDbQuery();
        String tableName = tableInfo.getName();
        try {
            Throwable throwable;
            Throwable throwable2;
            String tableFieldsSql = dbQuery.tableFieldsSql();
            HashSet<String> h2PkColumns = new HashSet<String>();
            if (DbType.POSTGRE_SQL == dbType) {
                tableFieldsSql = String.format(tableFieldsSql, this.dataSourceConfig.getSchemaName(), tableName);
            } else if (DbType.KINGBASE_ES == dbType) {
                tableFieldsSql = String.format(tableFieldsSql, this.dataSourceConfig.getSchemaName(), tableName);
            } else if (DbType.OSCAR == dbType) {
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            } else if (DbType.DB2 == dbType) {
                tableFieldsSql = String.format(tableFieldsSql, this.dataSourceConfig.getSchemaName(), tableName);
            } else if (DbType.ORACLE == dbType) {
                tableName = tableName.toUpperCase();
                tableFieldsSql = String.format(tableFieldsSql.replace("#schema", this.dataSourceConfig.getSchemaName()), tableName);
            } else if (DbType.DM == dbType) {
                tableName = tableName.toUpperCase();
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            } else if (DbType.H2 == dbType) {
                throwable2 = null;
                try (PreparedStatement pkQueryStmt = this.connection.prepareStatement(String.format("select * from INFORMATION_SCHEMA.INDEXES WHERE TABLE_NAME = '%s'", tableName));){
                    throwable = null;
                    try (ResultSet pkResults = pkQueryStmt.executeQuery();){
                        while (pkResults.next()) {
                            String primaryKey = pkResults.getString(dbQuery.fieldKey());
                            if (!Boolean.parseBoolean(primaryKey)) continue;
                            h2PkColumns.add(pkResults.getString(dbQuery.fieldName()));
                        }
                    }
                    catch (Throwable primaryKey) {
                        throwable = primaryKey;
                        throw primaryKey;
                    }
                }
                catch (Throwable pkResults) {
                    throwable2 = pkResults;
                    throw pkResults;
                }
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            } else {
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            }
            throwable2 = null;
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(tableFieldsSql);){
                throwable = null;
                try (ResultSet results = preparedStatement.executeQuery();){
                    while (results.next()) {
                        List<TableFill> tableFillList;
                        boolean isId;
                        TableField field = new TableField();
                        String columnName = results.getString(dbQuery.fieldName());
                        if (DbType.H2 == dbType) {
                            isId = h2PkColumns.contains(columnName);
                        } else {
                            String key = results.getString(dbQuery.fieldKey());
                            if (DbType.DB2 == dbType || DbType.SQLITE == dbType) {
                                isId = StringUtils.isNotBlank((CharSequence)key) && "1".equals(key);
                            } else {
                                boolean bl = isId = StringUtils.isNotBlank((CharSequence)key) && "PRI".equals(key.toUpperCase());
                            }
                        }
                        if (isId && !haveId) {
                            haveId = true;
                            field.setKeyFlag(true);
                            tableInfo.setHavePrimaryKey(true);
                            field.setKeyIdentityFlag(dbQuery.isKeyIdentity(results));
                        } else {
                            field.setKeyFlag(false);
                        }
                        String[] fcs = dbQuery.fieldCustom();
                        if (null != fcs) {
                            HashMap customMap = CollectionUtils.newHashMapWithExpectedSize((int)fcs.length);
                            for (String fc : fcs) {
                                customMap.put(fc, results.getObject(fc));
                            }
                            field.setCustomMap(customMap);
                        }
                        field.setName(columnName);
                        String newColumnName = columnName;
                        IKeyWordsHandler keyWordsHandler = this.dataSourceConfig.getKeyWordsHandler();
                        if (keyWordsHandler != null && keyWordsHandler.isKeyWords(columnName)) {
                            System.err.println(String.format("\u5f53\u524d\u8868[%s]\u5b58\u5728\u5b57\u6bb5[%s]\u4e3a\u6570\u636e\u5e93\u5173\u952e\u5b57\u6216\u4fdd\u7559\u5b57!", tableName, columnName));
                            field.setKeyWords(true);
                            newColumnName = keyWordsHandler.formatColumn(columnName);
                        }
                        field.setColumnName(newColumnName);
                        field.setType(results.getString(dbQuery.fieldType()));
                        INameConvert nameConvert = this.strategyConfig.getNameConvert();
                        if (null != nameConvert) {
                            field.setPropertyName(nameConvert.propertyNameConvert(field));
                        } else {
                            field.setPropertyName(this.strategyConfig, this.processName(field.getName(), config.getColumnNaming()));
                        }
                        field.setColumnType(this.dataSourceConfig.getTypeConvert().processTypeConvert(this.globalConfig, field));
                        String fieldCommentColumn = dbQuery.fieldComment();
                        if (StringUtils.isNotBlank((CharSequence)fieldCommentColumn)) {
                            field.setComment(this.formatComment(results.getString(fieldCommentColumn)));
                        }
                        if (null != (tableFillList = this.getStrategyConfig().getTableFillList())) {
                            tableFillList.stream().filter(tf -> tf.getFieldName().equalsIgnoreCase(field.getName())).findFirst().ifPresent(tf -> field.setFill(tf.getFieldFill().name()));
                        }
                        if (this.strategyConfig.includeSuperEntityColumns(field.getName())) {
                            commonFieldList.add(field);
                            continue;
                        }
                        fieldList.add(field);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
        }
        catch (SQLException e) {
            System.err.println("SQL Exception\uff1a" + e.getMessage());
        }
        tableInfo.setFields(fieldList);
        tableInfo.setCommonFields(commonFieldList);
        return tableInfo;
    }

    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isBlank((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private String joinPackage(String parent, String subPackage) {
        return StringUtils.isBlank((CharSequence)parent) ? subPackage : parent + "." + subPackage;
    }

    private String processName(String name, NamingStrategy strategy) {
        return this.processName(name, strategy, this.strategyConfig.getFieldPrefix());
    }

    private String processName(String name, NamingStrategy strategy, String[] prefix) {
        String propertyName = ArrayUtils.isNotEmpty((Object[])prefix) ? (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.removePrefixAndCamel(name, prefix) : NamingStrategy.removePrefix(name, prefix)) : (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.underlineToCamel(name) : name);
        return propertyName;
    }

    public StrategyConfig getStrategyConfig() {
        return this.strategyConfig;
    }

    public ConfigBuilder setStrategyConfig(StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
        return this;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public ConfigBuilder setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public InjectionConfig getInjectionConfig() {
        return this.injectionConfig;
    }

    public ConfigBuilder setInjectionConfig(InjectionConfig injectionConfig) {
        this.injectionConfig = injectionConfig;
        return this;
    }

    public String formatComment(String comment) {
        return StringUtils.isBlank((CharSequence)comment) ? "" : comment.replaceAll("\r\n", "\t");
    }
}

