/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config.builder;

import com.baomidou.mybatisplus.generator.IDatabaseQuery;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.OutputFile;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.builder.GeneratorBuilder;
import com.baomidou.mybatisplus.generator.config.builder.PathInfoHandler;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigBuilder {
    private final TemplateConfig templateConfig;
    private final List<TableInfo> tableInfoList = new ArrayList<TableInfo>();
    private final Map<OutputFile, String> pathInfo = new HashMap<OutputFile, String>();
    private StrategyConfig strategyConfig;
    private GlobalConfig globalConfig;
    private InjectionConfig injectionConfig;
    private static final Pattern REGX = Pattern.compile("[~!/@#$%^&*()+\\\\\\[\\]|{};:'\",<.>?]+");
    private final PackageConfig packageConfig;
    private final DataSourceConfig dataSourceConfig;

    public ConfigBuilder(@Nullable PackageConfig packageConfig, @NotNull DataSourceConfig dataSourceConfig, @Nullable StrategyConfig strategyConfig, @Nullable TemplateConfig templateConfig, @Nullable GlobalConfig globalConfig, @Nullable InjectionConfig injectionConfig) {
        this.dataSourceConfig = dataSourceConfig;
        this.strategyConfig = Optional.ofNullable(strategyConfig).orElseGet(() -> GeneratorBuilder.strategyConfig());
        this.globalConfig = Optional.ofNullable(globalConfig).orElseGet(() -> GeneratorBuilder.globalConfig());
        this.templateConfig = Optional.ofNullable(templateConfig).orElseGet(() -> GeneratorBuilder.templateConfig());
        this.packageConfig = Optional.ofNullable(packageConfig).orElseGet(() -> GeneratorBuilder.packageConfig());
        this.injectionConfig = Optional.ofNullable(injectionConfig).orElseGet(() -> GeneratorBuilder.injectionConfig());
        this.pathInfo.putAll(new PathInfoHandler(this.globalConfig, this.templateConfig, this.packageConfig).getPathInfo());
    }

    public static boolean matcherRegTable(@NotNull String tableName) {
        return REGX.matcher(tableName).find();
    }

    @NotNull
    public ConfigBuilder setStrategyConfig(@NotNull StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
        return this;
    }

    @NotNull
    public ConfigBuilder setGlobalConfig(@NotNull GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    @NotNull
    public ConfigBuilder setInjectionConfig(@NotNull InjectionConfig injectionConfig) {
        this.injectionConfig = injectionConfig;
        return this;
    }

    @NotNull
    public TemplateConfig getTemplateConfig() {
        return this.templateConfig;
    }

    @NotNull
    public List<TableInfo> getTableInfoList() {
        List<TableInfo> tableInfos;
        if (this.tableInfoList.isEmpty() && !(tableInfos = new IDatabaseQuery.DefaultDatabaseQuery(this).queryTables()).isEmpty()) {
            this.tableInfoList.addAll(tableInfos);
        }
        return this.tableInfoList;
    }

    @NotNull
    public Map<OutputFile, String> getPathInfo() {
        return this.pathInfo;
    }

    @NotNull
    public StrategyConfig getStrategyConfig() {
        return this.strategyConfig;
    }

    @NotNull
    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    @Nullable
    public InjectionConfig getInjectionConfig() {
        return this.injectionConfig;
    }

    @NotNull
    public PackageConfig getPackageConfig() {
        return this.packageConfig;
    }

    @NotNull
    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }
}

