/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.generator.config;

import com.baomidou.mybatisplus.generator.config.IConfigBuilder;
import com.baomidou.mybatisplus.generator.config.rules.DateType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger(GlobalConfig.class);
    private String outputDir = System.getProperty("os.name").toLowerCase().contains("windows") ? "D://" : "/tmp";
    @Deprecated
    private boolean fileOverride;
    private boolean open = true;
    private String author = "baomidou";
    private boolean kotlin;
    private boolean swagger;
    private boolean springdoc;
    private DateType dateType = DateType.TIME_PACK;
    private Supplier<String> commentDate = () -> new SimpleDateFormat("yyyy-MM-dd").format(new Date());

    private GlobalConfig() {
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    @Deprecated
    public boolean isFileOverride() {
        return this.fileOverride;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean isKotlin() {
        return this.kotlin;
    }

    public boolean isSwagger() {
        return this.springdoc ? false : this.swagger;
    }

    public boolean isSpringdoc() {
        return this.springdoc;
    }

    @NotNull
    public DateType getDateType() {
        return this.dateType;
    }

    @NotNull
    public String getCommentDate() {
        return this.commentDate.get();
    }

    public static class Builder
    implements IConfigBuilder<GlobalConfig> {
        private final GlobalConfig globalConfig = new GlobalConfig();

        @Deprecated
        public Builder fileOverride() {
            LOGGER.warn("\u5168\u5c40\u8986\u76d6\u5df2\u6709\u6587\u4ef6\u7684\u914d\u7f6e\u5df2\u5931\u6548\uff0c\u5df2\u8fc1\u79fb\u5230\u7b56\u7565\u914d\u7f6e\u4e2d");
            this.globalConfig.fileOverride = true;
            return this;
        }

        public Builder disableOpenDir() {
            this.globalConfig.open = false;
            return this;
        }

        public Builder outputDir(@NotNull String outputDir) {
            this.globalConfig.outputDir = outputDir;
            return this;
        }

        public Builder author(@NotNull String author) {
            this.globalConfig.author = author;
            return this;
        }

        public Builder enableKotlin() {
            this.globalConfig.kotlin = true;
            return this;
        }

        public Builder enableSwagger() {
            this.globalConfig.swagger = true;
            return this;
        }

        public Builder enableSpringdoc() {
            this.globalConfig.springdoc = true;
            return this;
        }

        public Builder dateType(@NotNull DateType dateType) {
            this.globalConfig.dateType = dateType;
            return this;
        }

        public Builder commentDate(@NotNull Supplier<String> commentDate) {
            this.globalConfig.commentDate = commentDate;
            return this;
        }

        public Builder commentDate(@NotNull String pattern) {
            return this.commentDate(() -> new SimpleDateFormat(pattern).format(new Date()));
        }

        @Override
        public GlobalConfig build() {
            return this.globalConfig;
        }
    }
}

