/*
 * Decompiled with CFR 0.152.
 */
package com.battcn.boot.swagger.configuration;

import com.battcn.boot.swagger.utils.RequestUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerSecurityFilterPluginsConfiguration
implements Filter {
    private static Logger logger = LoggerFactory.getLogger(SwaggerSecurityFilterPluginsConfiguration.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("==================== init swagger security filter plugin ====================");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpSession session = request.getSession();
        if (session == null || session.getAttribute(session.getId()) == null) {
            RequestUtils.writeForbidden(response);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
        logger.info("==================== destroy swagger security filter plugin ====================");
    }
}

