/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.fs;

import asset.pipeline.AssetFile;
import asset.pipeline.AssetHelper;
import asset.pipeline.GenericAssetFile;
import asset.pipeline.fs.AbstractAssetResolver;
import asset.pipeline.fs.FileSystemAssetResolver;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Range;
import groovy.lang.Reference;
import groovy.transform.TypeChecked;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemAssetResolver
extends AbstractAssetResolver<File> {
    private static String QUOTED_FILE_SEPARATOR;
    private static String DIRECTIVE_FILE_SEPARATOR;
    private File baseDirectory;
    private List<String> scanDirectories;
    private List<FileSystemAssetResolver> resolvers;
    private static final transient Log log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1443888208854;
    private static /* synthetic */ SoftReference $callSiteArray;

    public FileSystemAssetResolver(String name, String basePath, boolean flattenSubDirectories) {
        List list;
        List list2;
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        super(name);
        this.scanDirectories = list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.resolvers = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Object object = callSiteArray[0].callConstructor(File.class, (Object)basePath);
        this.baseDirectory = (File)ScriptBytecodeAdapter.castToType((Object)object, File.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[1].call((Object)this.baseDirectory))) {
            if (flattenSubDirectories) {
                Object scopedDirectories = callSiteArray[2].call((Object)this.baseDirectory);
                Object scopedDirectory = null;
                Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(scopedDirectories), Iterator.class);
                while (iterator.hasNext()) {
                    scopedDirectory = iterator.next();
                    if (!(DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[4].call(scopedDirectory)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call(callSiteArray[6].call(scopedDirectory), (Object)".")) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[7].call(scopedDirectory), (Object)"WEB-INF") && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[8].call(scopedDirectory), (Object)"META-INF"))) continue;
                    callSiteArray[9].call(this.resolvers, callSiteArray[10].callConstructor(FileSystemAssetResolver.class, (Object)name, callSiteArray[11].callGetProperty(scopedDirectory), (Object)false));
                }
            } else {
                callSiteArray[12].call(this.scanDirectories, callSiteArray[13].callGetProperty((Object)this.baseDirectory));
            }
        }
        Object object2 = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[14].call((Object)log)) ? callSiteArray[15].call((Object)log, (Object)new GStringImpl(new Object[]{this.scanDirectories}, new String[]{"Asset Pipeline FSResolver Initialized with Scan Directories: ", ""})) : null;
    }

    public FileSystemAssetResolver(String name, String basePath) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        this(name, basePath, true);
    }

    @Override
    public AssetFile getAsset(String relativePath, String contentType, String extension, AssetFile baseFile) {
        Reference extension2 = new Reference((Object)extension);
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)relativePath)) {
            return (AssetFile)ScriptBytecodeAdapter.castToType(null, AssetFile.class);
        }
        Object object = callSiteArray[16].call((Object)relativePath, (Object)QUOTED_FILE_SEPARATOR, (Object)DIRECTIVE_FILE_SEPARATOR);
        relativePath = (String)ScriptBytecodeAdapter.castToType((Object)object, String.class);
        Object specs = null;
        if (DefaultTypeTransformation.booleanUnbox((Object)contentType)) {
            Object object2;
            specs = object2 = callSiteArray[17].call(AssetHelper.class, (Object)contentType);
        } else {
            Object object3;
            if (!DefaultTypeTransformation.booleanUnbox((Object)((String)extension2.get()))) {
                Object object4 = callSiteArray[18].call(AssetHelper.class, (Object)relativePath);
                extension2.set((Object)((String)ScriptBytecodeAdapter.castToType((Object)object4, String.class)));
            }
            specs = object3 = callSiteArray[19].call(callSiteArray[20].call(AssetHelper.class), (Object)new GeneratedClosure(this, this, extension2){
                private /* synthetic */ Reference extension;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    CallSite[] callSiteArray = _getAsset_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.extension = reference = extension;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _getAsset_closure1.$getCallSiteArray();
                    return callSiteArray[0].call(callSiteArray[1].callGetProperty(it), this.extension.get());
                }

                public String getExtension() {
                    CallSite[] callSiteArray = _getAsset_closure1.$getCallSiteArray();
                    return (String)ScriptBytecodeAdapter.castToType((Object)this.extension.get(), String.class);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _getAsset_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _getAsset_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public static /* synthetic */ void __$swapInit() {
                    CallSite[] callSiteArray = _getAsset_closure1.$getCallSiteArray();
                    $callSiteArray = null;
                }

                static {
                    _getAsset_closure1.__$swapInit();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "contains";
                    stringArray[1] = "extensions";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[2];
                    _getAsset_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_getAsset_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _getAsset_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }

                static /* synthetic */ Class class$(String string) {
                    try {
                        return Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
            });
        }
        Object directoryPath = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[21].call(this.scanDirectories), Iterator.class);
        while (iterator.hasNext()) {
            directoryPath = iterator.next();
            AssetFile assetFile = (AssetFile)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].callCurrent((GroovyObject)this, ArrayUtil.createArray((Object)specs, directoryPath, (Object)relativePath, (Object)baseFile, (Object)((String)extension2.get()))), AssetFile.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)assetFile)) continue;
            return assetFile;
        }
        Object resolver = null;
        Iterator iterator2 = (Iterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call(this.resolvers), Iterator.class);
        while (iterator2.hasNext()) {
            resolver = iterator2.next();
            AssetFile assetFile = (AssetFile)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(resolver, (Object)relativePath, (Object)contentType, (Object)((String)extension2.get()), (Object)baseFile), AssetFile.class);
            if (!DefaultTypeTransformation.booleanUnbox((Object)assetFile)) continue;
            return assetFile;
        }
        return (AssetFile)ScriptBytecodeAdapter.castToType(null, AssetFile.class);
    }

    @Override
    protected File getRelativeFile(String relativePath, String name) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].callConstructor(File.class, (Object)relativePath, (Object)name), File.class);
    }

    @Override
    protected Closure<InputStream> createInputStreamClosure(File file) {
        Reference file2 = new Reference((Object)file);
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[26].call((Object)((File)file2.get()))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].call((Object)((File)file2.get())))) {
                return new GeneratedClosure(this, this, file2){
                    private /* synthetic */ Reference file;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _createInputStreamClosure_closure2.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.file = reference = file;
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _createInputStreamClosure_closure2.$getCallSiteArray();
                        return callSiteArray[0].call(this.file.get());
                    }

                    public File getFile() {
                        CallSite[] callSiteArray = _createInputStreamClosure_closure2.$getCallSiteArray();
                        return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _createInputStreamClosure_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public static /* synthetic */ void __$swapInit() {
                        CallSite[] callSiteArray = _createInputStreamClosure_closure2.$getCallSiteArray();
                        $callSiteArray = null;
                    }

                    static {
                        _createInputStreamClosure_closure2.__$swapInit();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "newInputStream";
                        return new CallSiteArray(_createInputStreamClosure_closure2.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _createInputStreamClosure_closure2.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }

                    static /* synthetic */ Class class$(String string) {
                        try {
                            return Class.forName(string);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                };
            }
        } else if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].call((Object)((File)file2.get()))) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].call((Object)((File)file2.get())))) {
            return new /* invalid duplicate definition of identical inner class */;
        }
        return (Closure)ScriptBytecodeAdapter.castToType(null, Closure.class);
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABBMamF2YS91dGlsL0xpc3Q7AQAAAAEAAAAJQ2xhc3NOb2RlAAAaTGFzc2V0L3BpcGVsaW5lL0Fzc2V0RmlsZTsA/////wD/////")
    public List<AssetFile> getAssets(String basePath, String contentType, String extension, Boolean recursive, AssetFile relativeFile, AssetFile baseFile) {
        List fileList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        String translatedBasePath = basePath;
        if (!basePath.startsWith("/") && relativeFile != null) {
            String string;
            ArrayList pathArgs = DefaultTypeTransformation.booleanUnbox((Object)relativeFile.getParentPath()) ? DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)relativeFile.getParentPath().split(DIRECTIVE_FILE_SEPARATOR), Object[].class))) : new ArrayList();
            String[] basePathArgs = basePath.split(DIRECTIVE_FILE_SEPARATOR);
            List parentPathArgs = DefaultTypeTransformation.booleanUnbox(pathArgs) ? DefaultGroovyMethods.getAt(pathArgs, (Range)ScriptBytecodeAdapter.createRange((Object)0, (Object)(pathArgs.size() - 1), (boolean)true)) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            parentPathArgs.addAll(DefaultGroovyMethods.toList((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)basePathArgs, Object[].class))));
            translatedBasePath = string = DefaultGroovyMethods.join((Collection)parentPathArgs, (String)File.separator);
        }
        String directoryPath = null;
        Iterator<String> iterator = this.scanDirectories.iterator();
        while (iterator.hasNext()) {
            directoryPath = (String)ScriptBytecodeAdapter.castToType((Object)iterator.next(), String.class);
            File file = new File(directoryPath, translatedBasePath);
            if (!(file.exists() && file.isDirectory())) continue;
            this.recursiveTreeAppend(file, fileList, contentType, baseFile, DefaultTypeTransformation.booleanUnbox((Object)recursive), directoryPath);
        }
        FileSystemAssetResolver resolver = null;
        Iterator<FileSystemAssetResolver> iterator2 = this.resolvers.iterator();
        while (iterator2.hasNext()) {
            resolver = (FileSystemAssetResolver)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), FileSystemAssetResolver.class);
            Collection collection = DefaultGroovyMethods.plus((Collection)fileList, resolver.getAssets(basePath, contentType, extension, recursive, relativeFile, baseFile));
            fileList = (List)ScriptBytecodeAdapter.castToType((Object)collection, List.class);
        }
        return fileList;
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAAAFWAP////8=")
    protected void recursiveTreeAppend(File directory, List<AssetFile> tree, String contentType, AssetFile baseFile, boolean recursive, String sourceDirectory) {
        File[] files = directory.listFiles();
        File[] fileArray = (File[])ScriptBytecodeAdapter.asType(files != null ? DefaultGroovyMethods.sort((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)files, Object[].class)), (Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(File a, File b) {
                return a.getName().compareTo(b.getName());
            }

            public Object call(File a, File b) {
                return this.doCall(a, b);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _recursiveTreeAppend_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _recursiveTreeAppend_closure3.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_recursiveTreeAppend_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _recursiveTreeAppend_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }) : null, File[].class);
        files = fileArray;
        File file = null;
        Iterator iterator = (Iterator)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.iterator((Object)files), Iterator.class);
        while (iterator.hasNext()) {
            file = (File)ScriptBytecodeAdapter.castToType(iterator.next(), File.class);
            String[] mimeType = (String[])ScriptBytecodeAdapter.castToType(AssetHelper.assetMimeTypeForURI(file.getAbsolutePath()), String[].class);
            if (file.isDirectory() && recursive) {
                this.recursiveTreeAppend(file, tree, contentType, baseFile, recursive, sourceDirectory);
                continue;
            }
            if (!(!file.isDirectory() && DefaultTypeTransformation.booleanUnbox((Object)mimeType) && DefaultGroovyMethods.isCase((Object)mimeType, (Object)contentType))) continue;
            DefaultGroovyMethods.leftShift(tree, (Object)this.assetForFile(file, contentType, baseFile, sourceDirectory));
        }
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////w==")
    protected String getFileName(File file) {
        return file.getName();
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////w==")
    protected String relativePathToResolver(File file, String scanDirectoryPath) {
        String filePath = file.getCanonicalPath();
        if (filePath.startsWith(scanDirectoryPath)) {
            return filePath.substring(StringGroovyMethods.size((String)scanDirectoryPath) + 1).replace(File.separator, DIRECTIVE_FILE_SEPARATOR);
        }
        String scanDir = null;
        Iterator<String> iterator = this.scanDirectories.iterator();
        while (iterator.hasNext()) {
            scanDir = (String)ScriptBytecodeAdapter.castToType((Object)iterator.next(), String.class);
            if (!filePath.startsWith(scanDir)) continue;
            return filePath.substring(StringGroovyMethods.size((String)scanDir) + 1).replace(File.separator, DIRECTIVE_FILE_SEPARATOR);
        }
        throw (Throwable)new RuntimeException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{filePath, scanDirectoryPath}, new String[]{"File was not sourced from the same ScanDirectory ", " scanDir: ", ""}), String.class));
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABBMamF2YS91dGlsL0xpc3Q7AQAAAAEAAAAJQ2xhc3NOb2RlAAAaTGFzc2V0L3BpcGVsaW5lL0Fzc2V0RmlsZTsA/////wD/////")
    public Collection<AssetFile> scanForFiles(List<String> excludePatterns, List<String> includePatterns) {
        List fileList = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ArrayList<String> excludedPatternRegex = DefaultTypeTransformation.booleanUnbox(excludePatterns) ? excludePatterns : new ArrayList<String>();
        ArrayList<String> includedPatternRegex = DefaultTypeTransformation.booleanUnbox(includePatterns) ? includePatterns : new ArrayList<String>();
        String scanDirectory = null;
        Iterator<String> iterator = this.scanDirectories.iterator();
        while (iterator.hasNext()) {
            scanDirectory = (String)ScriptBytecodeAdapter.castToType((Object)iterator.next(), String.class);
            File scanPath = new File(scanDirectory);
            this.iterateOverFileSystem(scanPath, excludedPatternRegex, includedPatternRegex, fileList, scanDirectory);
        }
        FileSystemAssetResolver resolver = null;
        Iterator<FileSystemAssetResolver> iterator2 = this.resolvers.iterator();
        while (iterator2.hasNext()) {
            resolver = (FileSystemAssetResolver)ScriptBytecodeAdapter.castToType((Object)iterator2.next(), FileSystemAssetResolver.class);
            Collection collection = DefaultGroovyMethods.plus((Collection)fileList, resolver.scanForFiles(excludePatterns, includePatterns));
            fileList = (List)ScriptBytecodeAdapter.castToType((Object)collection, List.class);
        }
        DefaultGroovyMethods.unique((Collection)fileList, (Closure)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(AssetFile a, AssetFile b) {
                return a.getPath() == b.getPath() ? 0 : (a.getPath() == null ? -1 : (b.getPath() == null ? 1 : a.getPath().compareTo(b.getPath())));
            }

            public Object call(AssetFile a, AssetFile b) {
                return this.doCall(a, b);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _scanForFiles_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _scanForFiles_closure4.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_scanForFiles_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _scanForFiles_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        });
        return fileList;
    }

    /*
     * WARNING - void declaration
     */
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAAA5MamF2YS9pby9GaWxlOwD/////")
    protected Object iterateOverFileSystem(File dir, List<String> excludePatterns, List<String> includePatterns, List<AssetFile> fileList, String sourcePath) {
        void var3_3;
        Reference excludePatterns2 = new Reference(excludePatterns);
        Reference includePatterns2 = new Reference((Object)var3_3);
        Reference fileList2 = new Reference(fileList);
        Reference sourcePath2 = new Reference((Object)sourcePath);
        return dir.listFiles() != null ? DefaultGroovyMethods.each((Object)dir.listFiles(), (Closure)new GeneratedClosure(this, this, excludePatterns2, includePatterns2, sourcePath2, fileList2){
            private /* synthetic */ Reference excludePatterns;
            private /* synthetic */ Reference includePatterns;
            private /* synthetic */ Reference sourcePath;
            private /* synthetic */ Reference fileList;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                this.excludePatterns = reference4 = excludePatterns;
                this.includePatterns = reference3 = includePatterns;
                this.sourcePath = reference2 = sourcePath;
                this.fileList = reference = fileList;
            }

            public Object doCall(File file) {
                Reference file2 = new Reference((Object)file);
                String relativePath = ((FileSystemAssetResolver)ScriptBytecodeAdapter.castToType((Object)this.getProperty("owner"), FileSystemAssetResolver.class)).relativePathToResolver((File)file2.get(), (String)ScriptBytecodeAdapter.castToType((Object)this.sourcePath.get(), String.class));
                if (((File)file2.get()).isDirectory()) {
                    return ((FileSystemAssetResolver)ScriptBytecodeAdapter.castToType((Object)this.getProperty("owner"), FileSystemAssetResolver.class)).iterateOverFileSystem((File)file2.get(), (List)ScriptBytecodeAdapter.castToType((Object)this.excludePatterns.get(), List.class), (List)ScriptBytecodeAdapter.castToType((Object)this.includePatterns.get(), List.class), (List)ScriptBytecodeAdapter.castToType((Object)this.fileList.get(), List.class), (String)ScriptBytecodeAdapter.castToType((Object)this.sourcePath.get(), String.class));
                }
                if (!((AbstractAssetResolver)ScriptBytecodeAdapter.castToType((Object)this.getProperty("owner"), AbstractAssetResolver.class)).isFileMatchingPatterns(relativePath, (List)ScriptBytecodeAdapter.castToType((Object)this.excludePatterns.get(), List.class)) || ((AbstractAssetResolver)ScriptBytecodeAdapter.castToType((Object)this.getProperty("owner"), AbstractAssetResolver.class)).isFileMatchingPatterns(relativePath, (List)ScriptBytecodeAdapter.castToType((Object)this.includePatterns.get(), List.class))) {
                    if (!((File)file2.get()).isDirectory()) {
                        Class<AssetFile> assetFileClass = AssetHelper.assetForFileName(relativePath);
                        if (assetFileClass != null) {
                            return ((List)this.fileList.get()).add((AssetFile)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.newInstance(assetFileClass, (Object[])new Object[]{ScriptBytecodeAdapter.createMap((Object[])new Object[]{"inputStreamSource", new GeneratedClosure((Object)this, this.getThisObject(), file2){
                                private /* synthetic */ Reference file;
                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                public static transient /* synthetic */ boolean __$stMC;
                                private static /* synthetic */ SoftReference $callSiteArray;
                                {
                                    Reference reference;
                                    this.file = reference = file;
                                }

                                public Object doCall(Object it) {
                                    return ResourceGroovyMethods.newInputStream((File)((File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class)));
                                }

                                public File getFile() {
                                    return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                                }

                                public Object doCall() {
                                    return this.doCall(null);
                                }

                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                    if (((Object)((Object)this)).getClass() != _iterateOverFileSystem_closure5_closure6.class) {
                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                    }
                                    ClassInfo classInfo = $staticClassInfo;
                                    if (classInfo == null) {
                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                    }
                                    return classInfo.getMetaClass();
                                }

                                public static /* synthetic */ void __$swapInit() {
                                }

                                static {
                                    _iterateOverFileSystem_closure5_closure6.__$swapInit();
                                }

                                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                    String[] stringArray = new String[]{};
                                    return new CallSiteArray(_iterateOverFileSystem_closure5_closure6.class, stringArray);
                                }

                                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                    CallSiteArray callSiteArray;
                                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                        callSiteArray = _iterateOverFileSystem_closure5_closure6.$createCallSiteArray();
                                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                    }
                                    return callSiteArray.array;
                                }

                                static /* synthetic */ Class class$(String string) {
                                    try {
                                        return Class.forName(string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                            }, "baseFile", null, "path", relativePath, "sourceResolver", this.getThisObject()})}), AssetFile.class));
                        }
                        List list = (List)this.fileList.get();
                        GenericAssetFile genericAssetFile = new GenericAssetFile();
                        genericAssetFile.setInputStreamSource((Closure)new GeneratedClosure((Object)this, this.getThisObject(), file2){
                            private /* synthetic */ Reference file;
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;
                            private static /* synthetic */ SoftReference $callSiteArray;
                            {
                                Reference reference;
                                this.file = reference = file;
                            }

                            public Object doCall(Object it) {
                                return ResourceGroovyMethods.newInputStream((File)((File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class)));
                            }

                            public File getFile() {
                                return (File)ScriptBytecodeAdapter.castToType((Object)this.file.get(), File.class);
                            }

                            public Object doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _iterateOverFileSystem_closure5_closure7.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public static /* synthetic */ void __$swapInit() {
                            }

                            static {
                                _iterateOverFileSystem_closure5_closure7.__$swapInit();
                            }

                            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                                String[] stringArray = new String[]{};
                                return new CallSiteArray(_iterateOverFileSystem_closure5_closure7.class, stringArray);
                            }

                            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                                CallSiteArray callSiteArray;
                                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                                    callSiteArray = _iterateOverFileSystem_closure5_closure7.$createCallSiteArray();
                                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                                }
                                return callSiteArray.array;
                            }

                            static /* synthetic */ Class class$(String string) {
                                try {
                                    return Class.forName(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                        });
                        genericAssetFile.setPath(relativePath);
                        return list.add(genericAssetFile);
                    }
                    return null;
                }
                return null;
            }

            public Object call(File file) {
                Reference file2 = new Reference((Object)file);
                return this.doCall((File)file2.get());
            }

            public List getExcludePatterns() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.excludePatterns.get(), List.class);
            }

            public List getIncludePatterns() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.includePatterns.get(), List.class);
            }

            public String getSourcePath() {
                return (String)ScriptBytecodeAdapter.castToType((Object)this.sourcePath.get(), String.class);
            }

            public List getFileList() {
                return (List)ScriptBytecodeAdapter.castToType((Object)this.fileList.get(), List.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _iterateOverFileSystem_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _iterateOverFileSystem_closure5.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_iterateOverFileSystem_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _iterateOverFileSystem_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }) : null;
    }

    public /* synthetic */ Object this$dist$invoke$2(String name, Object args) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(FileSystemAssetResolver.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$2(String name, Object value) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, FileSystemAssetResolver.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$2(String name) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectField(FileSystemAssetResolver.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public AssetFile getAsset(String relativePath, String contentType, String extension) {
        Reference extension2 = new Reference((Object)extension);
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAsset(relativePath, contentType, (String)extension2.get(), null);
    }

    @Override
    public AssetFile getAsset(String relativePath, String contentType) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAsset(relativePath, contentType, null, null);
    }

    @Override
    public AssetFile getAsset(String relativePath) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAsset(relativePath, null, null, null);
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABBMamF2YS91dGlsL0xpc3Q7AQAAAAEAAAAJQ2xhc3NOb2RlAAAaTGFzc2V0L3BpcGVsaW5lL0Fzc2V0RmlsZTsA/////wD/////")
    public List<AssetFile> getAssets(String basePath, String contentType, String extension, Boolean recursive, AssetFile relativeFile) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, extension, recursive, relativeFile, null);
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABBMamF2YS91dGlsL0xpc3Q7AQAAAAEAAAAJQ2xhc3NOb2RlAAAaTGFzc2V0L3BpcGVsaW5lL0Fzc2V0RmlsZTsA/////wD/////")
    public List<AssetFile> getAssets(String basePath, String contentType, String extension, Boolean recursive) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, extension, recursive, null, null);
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABBMamF2YS91dGlsL0xpc3Q7AQAAAAEAAAAJQ2xhc3NOb2RlAAAaTGFzc2V0L3BpcGVsaW5lL0Fzc2V0RmlsZTsA/////wD/////")
    public List<AssetFile> getAssets(String basePath, String contentType, String extension) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, extension, true, null, null);
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABBMamF2YS91dGlsL0xpc3Q7AQAAAAEAAAAJQ2xhc3NOb2RlAAAaTGFzc2V0L3BpcGVsaW5lL0Fzc2V0RmlsZTsA/////wD/////")
    public List<AssetFile> getAssets(String basePath, String contentType) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, contentType, null, true, null, null);
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABBMamF2YS91dGlsL0xpc3Q7AQAAAAEAAAAJQ2xhc3NOb2RlAAAaTGFzc2V0L3BpcGVsaW5lL0Fzc2V0RmlsZTsA/////wD/////")
    public List<AssetFile> getAssets(String basePath) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        return this.getAssets(basePath, null, null, true, null, null);
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAAAFWAP////8=")
    protected void recursiveTreeAppend(File directory, List<AssetFile> tree, String contentType, AssetFile baseFile, String sourceDirectory) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        this.recursiveTreeAppend(directory, tree, contentType, baseFile, true, sourceDirectory);
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAAAFWAP////8=")
    protected void recursiveTreeAppend(File directory, List<AssetFile> tree, AssetFile baseFile, String sourceDirectory) {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        this.recursiveTreeAppend(directory, tree, null, baseFile, true, sourceDirectory);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileSystemAssetResolver.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ void __$swapInit() {
        CallSite[] callSiteArray = FileSystemAssetResolver.$getCallSiteArray();
        $callSiteArray = null;
    }

    static {
        String string;
        long l;
        long l2;
        FileSystemAssetResolver.__$swapInit();
        __timeStamp__239_neverHappen1443888208854 = l2 = 0L;
        __timeStamp = l = 1443888208854L;
        DIRECTIVE_FILE_SEPARATOR = string = "/";
        Object object = FileSystemAssetResolver.$getCallSiteArray()[30].call(Pattern.class, FileSystemAssetResolver.$getCallSiteArray()[31].callGetProperty(File.class));
        QUOTED_FILE_SEPARATOR = (String)ScriptBytecodeAdapter.castToType((Object)object, String.class);
        Object object2 = FileSystemAssetResolver.$getCallSiteArray()[32].call(LogFactory.class, FileSystemAssetResolver.class);
        log = (Log)ScriptBytecodeAdapter.castToType((Object)object2, Log.class);
    }

    public static String getQUOTED_FILE_SEPARATOR() {
        return QUOTED_FILE_SEPARATOR;
    }

    public static void setQUOTED_FILE_SEPARATOR(String string) {
        QUOTED_FILE_SEPARATOR = string;
    }

    public static String getDIRECTIVE_FILE_SEPARATOR() {
        return DIRECTIVE_FILE_SEPARATOR;
    }

    public static void setDIRECTIVE_FILE_SEPARATOR(String string) {
        DIRECTIVE_FILE_SEPARATOR = string;
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File file) {
        this.baseDirectory = file;
    }

    public List<String> getScanDirectories() {
        return this.scanDirectories;
    }

    public void setScanDirectories(List<String> list) {
        this.scanDirectories = list;
    }

    public List<FileSystemAssetResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(List<FileSystemAssetResolver> list) {
        this.resolvers = list;
    }

    public /* synthetic */ AssetFile super$2$assetForFile(Object object, String string, String string2) {
        return super.assetForFile(object, string, string2);
    }

    @Override
    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ Object super$2$invokeMethod(String string, Object object) {
        return super.invokeMethod(string, object);
    }

    @Override
    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Object super$2$getProperty(String string) {
        return super.getProperty(string);
    }

    public /* synthetic */ void super$2$setName(String string) {
        super.setName(string);
    }

    public /* synthetic */ void super$2$setProperty(String string, Object object) {
        super.setProperty(string, object);
    }

    public /* synthetic */ Object super$2$this$dist$invoke$1(String string, Object object) {
        return super.this$dist$invoke$1(string, object);
    }

    public /* synthetic */ AssetFile super$2$resolveAsset(Object object, String string, String string2, AssetFile assetFile, String string3) {
        return super.resolveAsset(object, string, string2, assetFile, string3);
    }

    @Override
    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$2$setMetaClass(MetaClass metaClass) {
        super.setMetaClass(metaClass);
    }

    public /* synthetic */ void super$2$this$dist$set$1(String string, Object object) {
        super.this$dist$set$1(string, object);
    }

    public /* synthetic */ boolean super$2$isFileMatchingPatterns(String string, List list) {
        return super.isFileMatchingPatterns(string, list);
    }

    public /* synthetic */ MetaClass super$2$getMetaClass() {
        return super.getMetaClass();
    }

    public /* synthetic */ Object super$2$this$dist$get$1(String string) {
        return super.this$dist$get$1(string);
    }

    public /* synthetic */ Pattern super$2$convertGlobToRegEx(String string) {
        return super.convertGlobToRegEx(string);
    }

    public /* synthetic */ String super$2$getName() {
        return super.getName();
    }

    public /* synthetic */ AssetFile super$2$assetForFile(Object object, String string, AssetFile assetFile, String string2) {
        return super.assetForFile(object, string, assetFile, string2);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "exists";
        stringArray[2] = "listFiles";
        stringArray[3] = "iterator";
        stringArray[4] = "isDirectory";
        stringArray[5] = "startsWith";
        stringArray[6] = "getName";
        stringArray[7] = "getName";
        stringArray[8] = "getName";
        stringArray[9] = "leftShift";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "canonicalPath";
        stringArray[12] = "leftShift";
        stringArray[13] = "canonicalPath";
        stringArray[14] = "isDebugEnabled";
        stringArray[15] = "debug";
        stringArray[16] = "replace";
        stringArray[17] = "getPossibleFileSpecs";
        stringArray[18] = "extensionFromURI";
        stringArray[19] = "findAll";
        stringArray[20] = "assetFileClasses";
        stringArray[21] = "iterator";
        stringArray[22] = "resolveAsset";
        stringArray[23] = "iterator";
        stringArray[24] = "getAsset";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "exists";
        stringArray[27] = "isDirectory";
        stringArray[28] = "exists";
        stringArray[29] = "isDirectory";
        stringArray[30] = "quote";
        stringArray[31] = "separator";
        stringArray[32] = "getLog";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[33];
        FileSystemAssetResolver.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(FileSystemAssetResolver.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileSystemAssetResolver.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

