/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline;

import asset.pipeline.AssetCompiler;
import asset.pipeline.AssetFile;
import asset.pipeline.AssetHelper;
import asset.pipeline.CacheManager;
import asset.pipeline.Processor;
import asset.pipeline.fs.AssetResolver;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.TypeChecked;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.EncodingGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAssetFile
implements AssetFile,
GroovyObject {
    private String path;
    private AssetFile baseFile;
    private AssetResolver sourceResolver;
    private String encoding;
    private Pattern directivePattern;
    private Closure inputStreamSource;
    private byte[] byteCache;
    private List<String> matchedDirectives;
    private DigestInputStream digestStream;
    private MessageDigest digest;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1449004423138;
    private static /* synthetic */ SoftReference $callSiteArray;

    public AbstractAssetFile() {
        MetaClass metaClass;
        List list;
        Object var1_1 = null;
        this.directivePattern = (Pattern)ScriptBytecodeAdapter.castToType(var1_1, Pattern.class);
        _closure1 _closure12 = new _closure1(this, this);
        this.inputStreamSource = _closure12;
        this.matchedDirectives = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAAB5MamF2YS9pby9CeXRlQXJyYXlJbnB1dFN0cmVhbTsA/////w==")
    public InputStream getInputStream() {
        if (this.byteCache == null) {
            DigestInputStream digestInputStream;
            MessageDigest messageDigest;
            this.digest = messageDigest = MessageDigest.getInstance("MD5");
            this.digestStream = digestInputStream = new DigestInputStream((InputStream)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeClosure((Object)this.inputStreamSource, (Object[])new Object[0]), InputStream.class), this.digest);
            byte[] byArray = IOGroovyMethods.getBytes((InputStream)this.digestStream);
            this.byteCache = byArray;
        }
        return new ByteArrayInputStream(this.byteCache);
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////w==")
    public String getByteDigest() {
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.digestStream) || !DefaultTypeTransformation.booleanUnbox((Object)this.digest)) {
            this.getInputStream();
        }
        try {
            byte[] buffer = new byte[1024];
            int nRead = 0;
            while (true) {
                int n;
                nRead = n = this.digestStream.read(buffer, 0, buffer.length);
                if (ScriptBytecodeAdapter.compareNotEqual((Object)n, (Object)-1)) {
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
        }
        return EncodingGroovyMethods.encodeHex((byte[])this.digest.digest()).toString();
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////w==")
    public String getCanonicalPath() {
        return this.path;
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////w==")
    public String getParentPath() {
        String[] pathArgs = this.path.split("/");
        if (DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)pathArgs, Object[].class))) == 1) {
            return (String)ScriptBytecodeAdapter.castToType(null, String.class);
        }
        return DefaultGroovyMethods.join((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)((String[])ScriptBytecodeAdapter.asType((Object)Arrays.copyOfRange((Object[])ScriptBytecodeAdapter.castToType((Object)pathArgs, Object[].class), 0, DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)pathArgs, Object[].class))) - 1), String[].class)), Object[].class)), (String)"/");
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////w==")
    public String getName() {
        return (String)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])this.path.split("/"), (int)-1), String.class);
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////w==")
    public String processedStream(AssetCompiler precompiler) {
        String fileText = null;
        AssetCompiler assetCompiler = precompiler;
        Boolean skipCache = (Boolean)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)assetCompiler) ? assetCompiler : Boolean.valueOf(!DefaultTypeTransformation.booleanUnbox((Object)this.getProperty("processors")) || ((List)this.getProperty("processors")).size() == 0)), Boolean.class);
        Object cacheKey = null;
        if (DefaultTypeTransformation.booleanUnbox(this.baseFile != null ? this.baseFile.getEncoding() : null) || DefaultTypeTransformation.booleanUnbox((Object)this.encoding)) {
            String string = this.getInputStream() != null ? IOGroovyMethods.getText((InputStream)this.getInputStream(), (String)(DefaultTypeTransformation.booleanUnbox(this.baseFile != null ? this.baseFile.getEncoding() : null) ? this.baseFile.getEncoding() : this.encoding)) : null;
            fileText = (String)ScriptBytecodeAdapter.castToType(string, String.class);
        } else {
            String string;
            fileText = string = IOGroovyMethods.getText((InputStream)this.getInputStream());
        }
        String md5 = null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)skipCache)) {
            String string;
            md5 = string = AssetHelper.getByteDigest(fileText.getBytes());
            String cache = CacheManager.findCache(this.path, md5, this.baseFile != null ? this.baseFile.getPath() : null);
            if (DefaultTypeTransformation.booleanUnbox((Object)cache)) {
                return cache;
            }
        }
        if (this.getProperty("processors") != null) {
            Class processor = null;
            Iterator iterator = ((List)this.getProperty("processors")).iterator();
            while (iterator.hasNext()) {
                String string;
                processor = (Class)ScriptBytecodeAdapter.castToType(iterator.next(), Class.class);
                Processor processInstance = (Processor)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.newInstance((Class)processor, (Object[])new Object[]{precompiler}), Processor.class);
                fileText = string = processInstance.process(fileText, this);
            }
        }
        if (!DefaultTypeTransformation.booleanUnbox((Object)skipCache)) {
            CacheManager.createCache(this.path, md5, fileText, this.baseFile != null ? this.baseFile.getPath() : null);
        }
        return fileText;
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////w==")
    public String toString() {
        return this.path;
    }

    @Override
    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABlMamF2YS91dGlsL3JlZ2V4L1BhdHRlcm47AP////8=")
    public Pattern getDirectivePattern() {
        return this.directivePattern;
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABdMZ3Jvb3Z5L2xhbmcvTWV0YUNsYXNzOwD/////")
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractAssetFile.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL09iamVjdDsA/////w==")
    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AbstractAssetFile.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAAAFWAP////8=")
    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, AbstractAssetFile.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL09iamVjdDsA/////w==")
    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(AbstractAssetFile.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        long l;
        long l2;
        AbstractAssetFile.__$swapInit();
        __timeStamp__239_neverHappen1449004423138 = l2 = 0L;
        __timeStamp = l = 1449004423138L;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    @Override
    public AssetFile getBaseFile() {
        return this.baseFile;
    }

    @Override
    public void setBaseFile(AssetFile assetFile) {
        this.baseFile = assetFile;
    }

    @Override
    public AssetResolver getSourceResolver() {
        return this.sourceResolver;
    }

    public void setSourceResolver(AssetResolver assetResolver) {
        this.sourceResolver = assetResolver;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setDirectivePattern(Pattern pattern) {
        this.directivePattern = pattern;
    }

    public Closure getInputStreamSource() {
        return this.inputStreamSource;
    }

    public void setInputStreamSource(Closure closure) {
        this.inputStreamSource = closure;
    }

    public byte[] getByteCache() {
        return this.byteCache;
    }

    public void setByteCache(byte ... byArray) {
        this.byteCache = byArray;
    }

    @Override
    public List<String> getMatchedDirectives() {
        return this.matchedDirectives;
    }

    @Override
    public void setMatchedDirectives(List<String> list) {
        this.matchedDirectives = list;
    }

    public DigestInputStream getDigestStream() {
        return this.digestStream;
    }

    public void setDigestStream(DigestInputStream digestInputStream) {
        this.digestStream = digestInputStream;
    }

    public MessageDigest getDigest() {
        return this.digest;
    }

    public void setDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(AbstractAssetFile.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AbstractAssetFile.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private static /* synthetic */ SoftReference $callSiteArray;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            return null;
        }

        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            _closure1.__$swapInit();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(_closure1.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = _closure1.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

