/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.ureport.console.cache;

import com.bstek.ureport.console.RequestHolder;
import com.bstek.ureport.console.cache.ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class TempObjectCache {
    private static TempObjectCache tempObjectCache = new TempObjectCache();
    private Map<String, ObjectMap> sessionMap = new HashMap<String, ObjectMap>();

    public static Object getObject(String key) {
        return tempObjectCache.get(key);
    }

    public static void putObject(String key, Object obj) {
        tempObjectCache.store(key, obj);
    }

    public static void removeObject(String key) {
        tempObjectCache.remove(key);
    }

    public void remove(String key) {
        HttpServletRequest req = RequestHolder.getRequest();
        if (req == null) {
            return;
        }
        ObjectMap mapObject = this.getReportMap(req);
        if (mapObject != null) {
            mapObject.remove(key);
        }
    }

    public Object get(String key) {
        HttpServletRequest req = RequestHolder.getRequest();
        if (req == null) {
            return null;
        }
        ObjectMap mapObject = this.getReportMap(req);
        return mapObject.get(key);
    }

    public void store(String key, Object obj) {
        HttpServletRequest req = RequestHolder.getRequest();
        if (req == null) {
            return;
        }
        ObjectMap mapObject = this.getReportMap(req);
        mapObject.put(key, obj);
    }

    private ObjectMap getReportMap(HttpServletRequest req) {
        ArrayList<String> expiredList = new ArrayList<String>();
        for (String key : this.sessionMap.keySet()) {
            ObjectMap reportObj = this.sessionMap.get(key);
            if (!reportObj.isExpired()) continue;
            expiredList.add(key);
        }
        for (String key : expiredList) {
            this.sessionMap.remove(key);
        }
        String sessionId = req.getSession().getId();
        ObjectMap obj = this.sessionMap.get(sessionId);
        if (obj != null) {
            return obj;
        }
        ObjectMap mapObject = new ObjectMap();
        this.sessionMap.put(sessionId, mapObject);
        return mapObject;
    }
}

