/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.UUID;

public class ClickHouseUuidValue
extends ClickHouseObjectValue<UUID> {
    public static final UUID DEFAULT = new UUID(0L, 0L);

    public static ClickHouseUuidValue ofNull() {
        return ClickHouseUuidValue.ofNull(null);
    }

    public static ClickHouseUuidValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseUuidValue ? (ClickHouseUuidValue)((ClickHouseUuidValue)ref).set(null) : new ClickHouseUuidValue(null);
    }

    public static ClickHouseUuidValue of(UUID value) {
        return ClickHouseUuidValue.of(null, value);
    }

    public static ClickHouseUuidValue of(ClickHouseValue ref, UUID value) {
        return ref instanceof ClickHouseUuidValue ? (ClickHouseUuidValue)((ClickHouseUuidValue)ref).set(value) : new ClickHouseUuidValue(value);
    }

    protected ClickHouseUuidValue(UUID value) {
        super(value);
    }

    @Override
    public ClickHouseUuidValue copy(boolean deep) {
        return new ClickHouseUuidValue((UUID)this.getValue());
    }

    @Override
    public byte asByte() {
        return this.isNullOrEmpty() ? (byte)0 : this.asBigInteger().byteValueExact();
    }

    @Override
    public short asShort() {
        return this.isNullOrEmpty() ? (short)0 : this.asBigInteger().shortValueExact();
    }

    @Override
    public int asInteger() {
        return this.isNullOrEmpty() ? 0 : this.asBigInteger().intValueExact();
    }

    @Override
    public long asLong() {
        return this.isNullOrEmpty() ? 0L : this.asBigInteger().longValueExact();
    }

    @Override
    public BigInteger asBigInteger() {
        return ClickHouseValues.convertToBigInteger((UUID)this.getValue());
    }

    @Override
    public float asFloat() {
        return this.isNullOrEmpty() ? 0.0f : this.asBigInteger().floatValue();
    }

    @Override
    public double asDouble() {
        return this.isNullOrEmpty() ? 0.0 : this.asBigInteger().doubleValue();
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        return this.isNullOrEmpty() ? null : new BigDecimal(this.asBigInteger(), scale);
    }

    @Override
    public Object asObject() {
        return this.getValue();
    }

    @Override
    public UUID asUuid() {
        return (UUID)this.getValue();
    }

    @Override
    public ClickHouseUuidValue resetToDefault() {
        this.set(DEFAULT);
        return this;
    }

    @Override
    public String toSqlExpression() {
        if (this.isNullOrEmpty()) {
            return "NULL";
        }
        return '\'' + ((UUID)this.getValue()).toString() + '\'';
    }

    @Override
    public ClickHouseUuidValue update(byte value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseUuidValue update(short value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseUuidValue update(int value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseUuidValue update(long value) {
        return this.update(BigInteger.valueOf(value));
    }

    @Override
    public ClickHouseUuidValue update(float value) {
        return this.update(BigDecimal.valueOf(value).toBigIntegerExact());
    }

    @Override
    public ClickHouseUuidValue update(double value) {
        return this.update(BigDecimal.valueOf(value).toBigIntegerExact());
    }

    @Override
    public ClickHouseUuidValue update(BigInteger value) {
        this.set(ClickHouseValues.convertToUuid(value));
        return this;
    }

    @Override
    public ClickHouseUuidValue update(BigDecimal value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(value.toBigIntegerExact());
        }
        return this;
    }

    @Override
    public ClickHouseUuidValue update(Enum<?> value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.ordinal()));
        }
        return this;
    }

    @Override
    public ClickHouseUuidValue update(Inet4Address value) {
        return this.update(ClickHouseValues.convertToBigInteger(value));
    }

    @Override
    public ClickHouseUuidValue update(Inet6Address value) {
        return this.update(ClickHouseValues.convertToBigInteger(value));
    }

    @Override
    public ClickHouseUuidValue update(LocalDate value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.toEpochDay()));
        }
        return this;
    }

    @Override
    public ClickHouseUuidValue update(LocalTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.toSecondOfDay()));
        }
        return this;
    }

    @Override
    public ClickHouseUuidValue update(LocalDateTime value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.update(BigInteger.valueOf(value.toEpochSecond(ZoneOffset.UTC)));
        }
        return this;
    }

    @Override
    public ClickHouseUuidValue update(String value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(UUID.fromString(value));
        }
        return this;
    }

    @Override
    public ClickHouseUuidValue update(UUID value) {
        this.set(value);
        return this;
    }

    @Override
    public ClickHouseUuidValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else {
            this.set(value.asUuid());
        }
        return this;
    }

    @Override
    public ClickHouseUuidValue update(Object value) {
        if (value instanceof UUID) {
            this.set((UUID)value);
        } else {
            super.update(value);
        }
        return this;
    }
}

