/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.stream;

import com.clickhouse.client.ClickHouseByteBuffer;
import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseDataUpdater;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseOutputStream;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.stream.AbstractByteArrayInputStream;
import com.clickhouse.client.stream.EmptyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Function;

public final class IterableMultipleInputStream<T>
extends AbstractByteArrayInputStream {
    private final Function<T, InputStream> func;
    private final Iterator<T> it;
    private ClickHouseInputStream in;

    private ClickHouseInputStream getInputStream() throws IOException {
        if (this.in == EmptyInputStream.INSTANCE || this.in.isClosed() || this.in.available() < 1) {
            while (this.it.hasNext()) {
                InputStream i = this.func.apply(this.it.next());
                if (i == null) continue;
                this.in = ClickHouseInputStream.of(i, this.buffer.length);
                break;
            }
        }
        return this.in;
    }

    @Override
    protected int updateBuffer() throws IOException {
        int read;
        this.position = 0;
        if (this.closed) {
            this.limit = 0;
            return 0;
        }
        int off = 0;
        for (int len = this.buffer.length; len > 0 && (read = this.getInputStream().read(this.buffer, off, len)) != -1; len -= read) {
            off += read;
        }
        if (this.copyTo != null) {
            this.copyTo.write(this.buffer, 0, off);
        }
        this.limit = off;
        return this.limit - this.position;
    }

    public IterableMultipleInputStream(Iterable<T> source, Function<T, InputStream> converter, Runnable postCloseAction) {
        super(null, null, postCloseAction);
        this.func = ClickHouseChecker.nonNull(converter, "Converter");
        this.it = ClickHouseChecker.nonNull(source, "Source").iterator();
        this.in = EmptyInputStream.INSTANCE;
        this.buffer = new byte[((Integer)ClickHouseClientOption.BUFFER_SIZE.getDefaultValue()).intValue()];
        this.position = 0;
        this.limit = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            LinkedList<String> errors = new LinkedList<String>();
            try {
                this.in.close();
            }
            catch (Exception e) {
                errors.add(e.getMessage());
            }
            while (this.it.hasNext()) {
                try {
                    InputStream i = this.func.apply(this.it.next());
                    if (i == null) continue;
                    i.close();
                }
                catch (Exception e) {
                    errors.add(e.getMessage());
                }
            }
            if (!errors.isEmpty()) {
                throw new IOException("Failed to close input stream: " + String.join((CharSequence)"\n", errors));
            }
        }
        finally {
            super.close();
        }
    }

    @Override
    public ClickHouseByteBuffer readCustom(ClickHouseDataUpdater reader) throws IOException {
        if (reader == null) {
            return this.byteBuffer.reset();
        }
        this.ensureOpen();
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int offset = this.position;
        int length = 0;
        boolean more = true;
        while (more) {
            int remain = this.limit - this.position;
            if (remain < 1) {
                this.closeQuietly();
                more = false;
                continue;
            }
            int read = reader.update(this.buffer, this.position, this.limit);
            if (read == -1) {
                byte[] bytes = new byte[this.limit];
                System.arraycopy(this.buffer, this.position, bytes, this.position, remain);
                length += remain;
                this.position = this.limit;
                list.add(bytes);
                if (this.updateBuffer() >= 1) continue;
                this.closeQuietly();
                more = false;
                continue;
            }
            length += read;
            this.position += read;
            list.add(this.buffer);
            more = false;
        }
        return this.byteBuffer.update(list, offset, length);
    }

    @Override
    public long pipe(ClickHouseOutputStream output) throws IOException {
        long count = 0L;
        if (output == null || output.isClosed()) {
            return count;
        }
        this.ensureOpen();
        int remain = this.limit - this.position;
        if (remain > 0) {
            output.transferBytes(this.buffer, this.position, remain);
            count += (long)remain;
            this.position = this.limit;
        }
        count += IterableMultipleInputStream.pipe((InputStream)this.in, (OutputStream)output, this.buffer);
        while (this.it.hasNext()) {
            InputStream i = this.func.apply(this.it.next());
            if (i == null) continue;
            count += IterableMultipleInputStream.pipe(i, (OutputStream)output, this.buffer);
        }
        this.close();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n == Long.MAX_VALUE) {
            long count = this.in.skip(n);
            while (this.it.hasNext()) {
                InputStream i = null;
                try {
                    i = this.func.apply(this.it.next());
                    if (i == null) continue;
                    count += i.skip(n);
                    i.close();
                }
                finally {
                    if (i == null) continue;
                    try {
                        this.in.close();
                    }
                    catch (Exception exception) {}
                    this.in = ClickHouseInputStream.of(i, this.buffer.length);
                }
            }
            return count;
        }
        return super.skip(n);
    }
}

