/*
 * Decompiled with CFR 0.152.
 */
package com.cloudcontrolled.api.client;

import com.cloudcontrolled.api.client.ICloudControlClient;
import com.cloudcontrolled.api.client.auth.Credentials;
import com.cloudcontrolled.api.client.exception.AuthorizationException;
import com.cloudcontrolled.api.client.exception.CommunicationErrorException;
import com.cloudcontrolled.api.client.exception.ValidationConstraintViolationException;
import com.cloudcontrolled.api.client.support.CloudControlClientSupport;
import com.cloudcontrolled.api.client.util.HttpMethodUtil;
import com.cloudcontrolled.api.client.util.HttpStatus;
import com.cloudcontrolled.api.client.util.PathUtil;
import com.cloudcontrolled.api.client.util.ValidationUtil;
import com.cloudcontrolled.api.common.HttpMethod;
import com.cloudcontrolled.api.request.CreateTokenRequest;
import com.cloudcontrolled.api.request.Request;
import com.cloudcontrolled.api.response.CreateTokenResponse;
import com.cloudcontrolled.api.response.Response;
import org.apache.cxf.jaxrs.client.WebClient;

public class CloudControlClient
extends CloudControlClientSupport
implements ICloudControlClient {
    private Credentials credentials;

    private CloudControlClient() {
    }

    public CloudControlClient(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public void renewToken() {
        CreateTokenResponse createTokenResponse;
        CreateTokenRequest createTokenRequest = new CreateTokenRequest();
        createTokenRequest.setUser(this.credentials.getUserName());
        createTokenRequest.setPassword(this.credentials.getPassword());
        try {
            createTokenResponse = (CreateTokenResponse)this.send((Request)createTokenRequest);
        }
        catch (ValidationConstraintViolationException vcve) {
            throw new AuthorizationException(vcve);
        }
        HttpStatus status = HttpStatus.getStatus(createTokenResponse.getStatusCode());
        if (status.isError()) {
            if (status.equals((Object)HttpStatus.Unauthorized)) {
                throw new AuthorizationException(HttpStatus.Unauthorized.toString());
            }
            throw new CommunicationErrorException(status);
        }
        String newToken = createTokenResponse.getToken();
        this.tokenStore.setToken(newToken);
    }

    @Override
    public <T> T send(Request<T> request) {
        Response<T> response;
        if (request == null) {
            throw new CommunicationErrorException("Request cannot be null.");
        }
        PathUtil.infixPotentialDefaults(request);
        ValidationUtil.validate(request);
        try {
            response = this.dispatchByMethod(request);
        }
        catch (AuthorizationException ae) {
            this.renewToken();
            response = this.dispatchByMethod(request);
        }
        return (T)response;
    }

    private <T> Response<T> dispatchByMethod(Request<T> request) {
        HttpMethod method = HttpMethodUtil.retrieveMethod(request);
        String target = CloudControlClient.getTargetUrl();
        WebClient webClient = this.instantiateWebClient(target);
        webClient = this.prepareAuthorization(webClient, request);
        switch (method) {
            case GET: {
                return this.doGet(webClient, request);
            }
            case POST: {
                return this.doPost(webClient, request);
            }
            case PUT: {
                return this.doPut(webClient, request);
            }
            case DELETE: {
                return this.doDelete(webClient, request);
            }
        }
        throw new CommunicationErrorException(HttpStatus.Not_Implemented);
    }

    private <T> WebClient prepareAuthorization(WebClient webClient, Request<T> request) {
        webClient = request instanceof CreateTokenRequest ? this.setAuthorizationBase64(webClient, this.toBase64(((CreateTokenRequest)request).getUser(), ((CreateTokenRequest)request).getPassword())) : this.setAuthorizationCCAuthToken(webClient);
        return webClient;
    }
}

