/*
 * Decompiled with CFR 0.152.
 */
package com.cloudcontrolled.api.client.exception;

import com.cloudcontrolled.api.client.exception.CloudControlClientException;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;

public class ValidationConstraintViolationException
extends CloudControlClientException {
    private static final long serialVersionUID = 8653296771499098292L;
    private static String lineSeparator = System.getProperty("line.separator");
    private List<ConstraintViolation> constraintViolations = new LinkedList<ConstraintViolation>();

    public ValidationConstraintViolationException(Throwable th) {
        super(th);
    }

    public ValidationConstraintViolationException(List<ConstraintViolation> violations) {
        super(ValidationConstraintViolationException.inquireMessage(violations));
        this.constraintViolations = violations;
    }

    public ValidationConstraintViolationException(String pre, List<ConstraintViolation> violations) {
        super(ValidationConstraintViolationException.concat(pre, ValidationConstraintViolationException.inquireMessage(violations)));
        this.constraintViolations = violations;
    }

    public List<ConstraintViolation> getConstraintViolations() {
        return this.constraintViolations;
    }

    private static String inquireMessage(List<ConstraintViolation> violations) {
        String message = null;
        for (ConstraintViolation constraintViolation : violations) {
            message = ValidationConstraintViolationException.concat(message, constraintViolation.toString());
        }
        return message;
    }

    private static String concat(String a, String b) {
        return (a != null && !a.isEmpty() ? a + lineSeparator : "") + b;
    }

    public static class ConstraintViolation {
        private String hint;
        private Field field;

        private ConstraintViolation(String hint, Field field) {
            this.hint = hint;
            this.field = field;
        }

        public static ConstraintViolation newConstraintViolation(String hint, Field field) {
            return new ConstraintViolation(hint, field);
        }

        public String toString() {
            return "\t" + this.hint + " " + this.field;
        }
    }
}

