/*
 * Decompiled with CFR 0.152.
 */
package com.cloudcontrolled.api.client.json;

import com.cloudcontrolled.api.client.exception.SerializationException;
import com.cloudcontrolled.api.client.util.StandardizationUtil;
import com.cloudcontrolled.api.response.Response;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;

public class JsonDeserializer {
    protected Gson gson;

    public JsonDeserializer() {
        this.initializeGson();
    }

    private void initializeGson() {
        this.gson = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes fieldAttributes) {
                return fieldAttributes.getName().equalsIgnoreCase("serialVersionUUID");
            }

            public boolean shouldSkipClass(Class<?> arg0) {
                return false;
            }
        }}).create();
    }

    public <T> Response<T> fromJSON(String response, Response<T> target) {
        try {
            response = StandardizationUtil.getJSONStandardizer(target).normalize(response);
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
        try {
            Response<T> fromJson = (Response<T>)this.gson.fromJson(response, target.getClass());
            if (fromJson == null) {
                fromJson = target;
            }
            return fromJson;
        }
        catch (JsonSyntaxException jse) {
            throw new SerializationException(jse);
        }
    }
}

