/*
 * Decompiled with CFR 0.152.
 */
package com.cloudcontrolled.api.client.support;

import com.cloudcontrolled.api.client.exception.AuthorizationException;
import com.cloudcontrolled.api.client.util.HttpStatus;
import com.cloudcontrolled.api.client.util.PathUtil;
import com.cloudcontrolled.api.client.util.RequestUtil;
import com.cloudcontrolled.api.client.util.Timer;
import com.cloudcontrolled.api.request.CreateTokenRequest;
import com.cloudcontrolled.api.request.Request;
import com.cloudcontrolled.api.response.Response;
import java.io.InputStream;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.log4j.Logger;

public abstract class AbstractCloudControlClientSupport {
    protected final Logger log = Logger.getLogger(this.getClass());

    protected <T> Response<T> doGet(WebClient webClient, Request<T> request) {
        webClient = webClient.path((Object)this.inquirePath(request));
        Timer timer = Timer.tic();
        javax.ws.rs.core.Response cxfResponse = webClient.get();
        timer.toc();
        this.log.debug((Object)(cxfResponse.getStatus() + " " + webClient.getCurrentURI() + " took " + timer.getDifference() + "ms"));
        Response<T> response = this.toResponse(timer, cxfResponse, request);
        this.log.debug(response);
        return response;
    }

    protected <T> Response<T> doPost(WebClient webClient, Request<T> request) {
        webClient = webClient.path((Object)this.inquirePath(request));
        Timer timer = Timer.tic();
        javax.ws.rs.core.Response cxfResponse = webClient.post(RequestUtil.getBodyAsMultiValuedMap(request));
        timer.toc();
        this.log.debug((Object)(cxfResponse.getStatus() + " " + webClient.getCurrentURI() + " took " + timer.getDifference() + "ms"));
        Response<T> response = this.toResponse(timer, cxfResponse, request);
        this.log.debug(response);
        return response;
    }

    protected <T> Response<T> doPut(WebClient webClient, Request<T> request) {
        webClient = webClient.path((Object)this.inquirePath(request));
        Timer timer = Timer.tic();
        javax.ws.rs.core.Response cxfResponse = webClient.put(RequestUtil.getBodyAsMultiValuedMap(request));
        timer.toc();
        this.log.debug((Object)(cxfResponse.getStatus() + " " + webClient.getCurrentURI() + " took " + timer.getDifference() + "ms"));
        Response<T> response = this.toResponse(timer, cxfResponse, request);
        this.log.debug(response);
        return response;
    }

    protected <T> Response<T> doDelete(WebClient webClient, Request<T> request) {
        webClient = webClient.path((Object)this.inquirePath(request));
        Timer timer = Timer.tic();
        javax.ws.rs.core.Response cxfResponse = webClient.delete();
        timer.toc();
        this.log.debug((Object)(cxfResponse.getStatus() + " " + webClient.getCurrentURI() + " took " + timer.getDifference() + "ms"));
        Response<T> response = this.toResponse(timer, cxfResponse, request);
        this.log.debug(response);
        return response;
    }

    private <T> Response<T> toResponse(Timer timer, javax.ws.rs.core.Response cxfResponse, Request<T> request) {
        if (!(request instanceof CreateTokenRequest) && cxfResponse.getStatus() == HttpStatus.Unauthorized.ordinal()) {
            throw new AuthorizationException(HttpStatus.Unauthorized.toString());
        }
        InputStream inputStream = (InputStream)cxfResponse.getEntity();
        Response<T> response = null;
        HttpStatus status = HttpStatus.getStatus(cxfResponse.getStatus());
        response = status.isError() ? this.deserializeError(inputStream, request) : this.deserialize(inputStream, request);
        response.setStatusCode(status.getCode());
        response.setResponseTime(timer.getDifference());
        return response;
    }

    protected <T> String inquirePath(Request<T> request) {
        return PathUtil.resolveResourcePath(request);
    }

    protected abstract <T> Response<T> deserialize(String var1, Request<T> var2);

    protected abstract <T> Response<T> deserialize(InputStream var1, Request<T> var2);

    protected abstract <T> Response<T> deserializeError(InputStream var1, Request<T> var2);

    protected abstract <T> Response<T> deserializeError(String var1, Request<T> var2);
}

