/*
 * Decompiled with CFR 0.152.
 */
package com.cloudcontrolled.api.client.support;

import com.cloudcontrolled.api.client.auth.TokenStore;
import com.cloudcontrolled.api.client.exception.SerializationException;
import com.cloudcontrolled.api.client.json.JsonDeserializer;
import com.cloudcontrolled.api.client.security.DumbX509TrustManager;
import com.cloudcontrolled.api.client.support.AbstractCloudControlClientSupport;
import com.cloudcontrolled.api.client.util.Header;
import com.cloudcontrolled.api.client.util.RequestUtil;
import com.cloudcontrolled.api.request.Request;
import com.cloudcontrolled.api.response.Response;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.TrustManager;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public class CloudControlClientSupport
extends AbstractCloudControlClientSupport {
    protected static final String ENV_API_URL_KEY = "CCTRL_API_URL";
    protected static final String apiUrl = "https://api.cloudcontrol.com";
    protected TokenStore tokenStore = new TokenStore();
    protected JsonDeserializer jsonDeserializer = new JsonDeserializer();

    @Override
    protected <T> Response<T> deserializeError(InputStream inputStream, Request<T> request) {
        String content = null;
        try {
            content = IOUtils.readStringFromStream((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return this.deserializeError(content, request);
    }

    @Override
    protected <T> Response<T> deserializeError(String response, Request<T> request) {
        Response<T> target = RequestUtil.getInstanceOfParameterizedType(request);
        target.setError(true);
        target.setContent(response);
        return target;
    }

    @Override
    protected <T> Response<T> deserialize(InputStream inputStream, Request<T> request) {
        String content = null;
        try {
            content = IOUtils.readStringFromStream((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        return this.deserialize(content, request);
    }

    @Override
    protected <T> Response<T> deserialize(String response, Request<T> request) {
        Response<T> target = RequestUtil.getInstanceOfParameterizedType(request);
        target.setContent(response);
        target.setError(false);
        try {
            return this.jsonDeserializer.fromJSON(response, target);
        }
        catch (SerializationException jse) {
            return target;
        }
    }

    public static String getTargetUrl() {
        String targetUrl = System.getenv(ENV_API_URL_KEY);
        if (targetUrl != null) {
            return targetUrl;
        }
        targetUrl = apiUrl;
        return targetUrl;
    }

    protected String toBase64(String user, String password) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(user);
        stringBuffer.append(":");
        stringBuffer.append(password);
        return Base64Utility.encode((byte[])stringBuffer.toString().getBytes());
    }

    protected WebClient instantiateWebClient(String targetUrl) {
        WebClient webClient = WebClient.create((String)targetUrl).type("application/x-www-form-urlencoded").accept(new String[]{"text/plain"}).accept(new String[]{"application/json"});
        HTTPConduit conduit = WebClient.getConfig((Object)(webClient = Header.setHeader(webClient))).getHttpConduit();
        TLSClientParameters params = conduit.getTlsClientParameters();
        if (params == null) {
            params = new TLSClientParameters();
            conduit.setTlsClientParameters(params);
        }
        params.setTrustManagers(new TrustManager[]{new DumbX509TrustManager()});
        params.setDisableCNCheck(true);
        HTTPClientPolicy policy = new HTTPClientPolicy();
        policy.setConnectionTimeout(600000L);
        policy.setReceiveTimeout(600000L);
        policy.setAllowChunking(false);
        conduit.setClient(policy);
        return webClient;
    }

    protected WebClient setAuthorizationBase64(WebClient webClient, String base64) {
        return webClient.header("Authorization", new Object[]{"Basic " + base64});
    }

    protected WebClient setAuthorizationCCAuthToken(WebClient webClient) {
        return webClient.header("Authorization", new Object[]{"cc_auth_token=\"" + this.tokenStore.getToken() + "\""});
    }
}

