/*
 * Decompiled with CFR 0.152.
 */
package com.cloudcontrolled.api.client.util;

import com.cloudcontrolled.api.client.util.ArrayUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;

public class ClassUtil {
    public static <T> T getClassAnnotationValue(Class source, Class annotation, String attributeName, Class<T> expected) {
        Object instance = source.getAnnotation(annotation);
        Object value = null;
        if (instance != null) {
            try {
                value = instance.annotationType().getMethod(attributeName, new Class[0]).invoke(instance, new Object[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return (T)value;
    }

    public static <T> List<Field> getAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationClass) {
        Field[] allFields;
        LinkedList<Field> annotatedFields = new LinkedList<Field>();
        for (Field field : allFields = ClassUtil.getAllDeclaredFields(clazz)) {
            if (null == field.getAnnotation(annotationClass)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    public static Field[] getAllDeclaredFields(Class<?> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            declaredFields = ArrayUtils.concat(declaredFields, ClassUtil.getAllDeclaredFields(superClass));
        }
        return declaredFields;
    }

    public static <T> T getValueOf(Field field, Object reference, Class<?> referenceClazz, Class<T> valueType) {
        try {
            field.setAccessible(true);
            Object toReturn = field.get(reference);
            return (T)toReturn;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T getValueOf(String fieldName, Object reference, Class<?> referenceClazz, Class<T> valueType) {
        try {
            Field field = referenceClazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            Object toReturn = field.get(reference);
            return (T)toReturn;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object getValueOfField(Field field, Object ref) {
        field.setAccessible(true);
        Object value = null;
        try {
            value = field.get(ref);
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return value;
    }
}

