/*
 * Decompiled with CFR 0.152.
 */
package com.cloudcontrolled.api.client.util;

import com.cloudcontrolled.api.annotation.Default;
import com.cloudcontrolled.api.annotation.Path;
import com.cloudcontrolled.api.annotation.PathVariable;
import com.cloudcontrolled.api.client.util.ClassUtil;
import com.cloudcontrolled.api.request.Request;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathUtil {
    private static final String PATTERN = "\\$\\{(.*?)*\\}(.*?)";

    public static <T> void infixPotentialDefaults(Request<T> request) {
        PathUtil.infixPotentialDefaults(request, request.getClass(), true);
    }

    public static <T> void infixPotentialDefaults(Request<T> request, Class<?> targetClazz, boolean infixPotentialValuesOfSuperClass) {
        Field[] declaredFields;
        Class<?> superClass = targetClazz.getSuperclass();
        if (infixPotentialValuesOfSuperClass && superClass != null && superClass.equals(Request.class)) {
            PathUtil.infixPotentialDefaults(request, superClass, infixPotentialValuesOfSuperClass);
        }
        for (Field property : declaredFields = targetClazz.getDeclaredFields()) {
            Default defaultValue = property.getAnnotation(Default.class);
            if (null == defaultValue) continue;
            property.setAccessible(true);
            try {
                Object value = property.get(request);
                if (value != null && (!(value instanceof String) || !((String)value).isEmpty())) continue;
                property.set(request, defaultValue.value());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static <T> String resolveResourcePath(Request<T> request) {
        Class<?> clazz = request.getClass();
        String unresolvedPath = ClassUtil.getClassAnnotationValue(clazz, Path.class, "value", String.class);
        HashMap<String, String> patternMap = new HashMap<String, String>();
        for (Field field : clazz.getDeclaredFields()) {
            PathVariable part = field.getAnnotation(PathVariable.class);
            if (part == null) continue;
            try {
                String pattern = part.value();
                field.setAccessible(true);
                String value = (String)field.get(request);
                patternMap.put(pattern, value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(unresolvedPath);
        LinkedHashSet<String> placeholder = new LinkedHashSet<String>();
        while (matcher.find()) {
            placeholder.add(matcher.group());
        }
        for (String key : placeholder) {
            String found = (String)patternMap.get(key);
            if (found == null) continue;
            unresolvedPath = unresolvedPath.replace(key, found);
        }
        return unresolvedPath;
    }
}

