/*
 * Decompiled with CFR 0.152.
 */
package com.cloudcontrolled.api.client.util;

import com.cloudcontrolled.api.annotation.Required;
import com.cloudcontrolled.api.client.exception.ValidationConstraintViolationException;
import com.cloudcontrolled.api.request.Request;
import java.lang.reflect.Field;
import java.util.LinkedList;

public class ValidationUtil {
    private static final String preMessage = "Request breaks constraints.";

    public static <T> void validate(Request<T> request) throws ValidationConstraintViolationException {
        if (request != null) {
            Field[] fields;
            Class<?> clazz = request.getClass();
            LinkedList<ValidationConstraintViolationException.ConstraintViolation> leafs = new LinkedList<ValidationConstraintViolationException.ConstraintViolation>();
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (null == field.getAnnotation(Required.class)) continue;
                field.setAccessible(true);
                Object value = null;
                try {
                    value = field.get(request);
                }
                catch (Exception e) {
                    throw new ValidationConstraintViolationException(e);
                }
                if (value != null && (!(value instanceof String) || !((String)value).isEmpty())) continue;
                ValidationConstraintViolationException.ConstraintViolation violation = ValidationConstraintViolationException.ConstraintViolation.newConstraintViolation("@" + Required.class.getSimpleName(), field);
                leafs.add(violation);
            }
            if (!leafs.isEmpty()) {
                throw new ValidationConstraintViolationException(preMessage, leafs);
            }
        }
    }
}

