/*
 * Copyright 2012 Denis Neuling 
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 */
package com.cloudcontrolled.api.response.normalize;

/**
 * <p>
 * JSONNormalizer class.
 * </p>
 * 
 * @author Denis Neuling (denisneuling@gmail.com)
 * 
 */
public class JSONNormalizer {

	/**
	 * <p>
	 * normalize and map the <small>(json)</small> response.
	 * </p>
	 * 
	 * @param jsonResponse
	 *            a {@link java.lang.String} object.
	 * @throws java.lang.Exception
	 *             if any.
	 * @return a {@link java.lang.String} object.
	 */
	public String normalize(String jsonResponse) throws Exception {
		return jsonResponse;
	}
}
