/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common;

import com.cntaiping.ec.cloud.common.MessagesProvider;
import com.cntaiping.ec.cloud.common.exception.ExceptionUtil;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.MethodArgumentNotValidException;

public class DefaultMessagesProvider
implements MessagesProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessagesProvider.class);
    private MessageSource defaultMessageSource;
    private MessageSource errorMessageSource;
    private String defaultMappingCode;

    public MessageSource getDefaultMessageSource() {
        return this.defaultMessageSource;
    }

    public MessageSource getErrorMessageSource() {
        return this.errorMessageSource;
    }

    public String getDefaultErrorKey() {
        return this.defaultMappingCode;
    }

    public void setDefaultMessageSource(MessageSource defaultMessageSource) {
        this.defaultMessageSource = defaultMessageSource;
    }

    public void setErrorMessageSource(MessageSource errorMessageSource) {
        this.errorMessageSource = errorMessageSource;
    }

    public void setDefaultMappingCode(String defaultMappingCode) {
        this.defaultMappingCode = defaultMappingCode;
    }

    @Override
    public Object resolveError(Throwable th, Locale locale) {
        ConstraintViolationException cve;
        Set cvs;
        if (ExceptionUtil.isWrapped(th)) {
            th = th.getCause();
        }
        if (th instanceof MethodArgumentNotValidException) {
            return this.resolveMessageCode(this.errorMessageSource, (MessageSourceResolvable)((MethodArgumentNotValidException)th).getBindingResult().getFieldError(), locale);
        }
        if (th instanceof ConstraintViolationException && (cvs = (cve = (ConstraintViolationException)th).getConstraintViolations()) != null && !cvs.isEmpty()) {
            ConstraintViolation constraintViolation = (ConstraintViolation)cvs.iterator().next();
            return this.resolveMessageCode(this.errorMessageSource, constraintViolation.getPropertyPath().toString(), null, locale, this.defaultMappingCode, constraintViolation.getMessage());
        }
        if (th instanceof MessageSourceResolvable) {
            MessageSourceResolvable msr = (MessageSourceResolvable)th;
            String[] codes = msr.getCodes();
            String code = codes != null && codes.length > 0 ? codes[0] : null;
            return this.resolveMessageCode(this.errorMessageSource, code, msr.getArguments(), locale, this.defaultMappingCode, msr.getDefaultMessage());
        }
        String errorMsg = null;
        String message = th.getMessage();
        if (StringUtils.hasText((String)message)) {
            errorMsg = this.resolveMessageCode(this.errorMessageSource, message, null, locale);
        }
        if (errorMsg != null) {
            return errorMsg;
        }
        message = th.getClass().getName();
        errorMsg = this.resolveMessageCode(this.errorMessageSource, message, null, locale);
        if (errorMsg != null) {
            return errorMsg;
        }
        message = this.defaultMappingCode;
        errorMsg = this.resolveMessageCode(this.errorMessageSource, message, null, locale);
        if (errorMsg != null) {
            return errorMsg;
        }
        return th.getClass().getName() + (th.getMessage() != null ? ":" + th.getMessage() : "");
    }

    @Override
    public Object resolveError(String errorCode, Object[] arguments, String defaultMessage, Locale locale) {
        String message = this.resolveMessageCode(this.errorMessageSource, errorCode, arguments, locale);
        return message == null ? defaultMessage : message;
    }

    @Override
    public String getMessage(String key, Locale locale) {
        return this.resolveMessageCode(this.defaultMessageSource, key, null, locale, null, key);
    }

    @Override
    public String getMessage(String key, Object[] arguments, Locale locale) {
        return this.resolveMessageCode(this.defaultMessageSource, key, arguments, locale, null, key);
    }

    private String resolveMessageCode(MessageSource messageSource, String code, Object[] args, Locale locale, String fallbackCode, String defaultMessage) {
        try {
            return messageSource.getMessage(code, args, locale);
        }
        catch (NoSuchMessageException e) {
            if (fallbackCode != null) {
                try {
                    return messageSource.getMessage(fallbackCode, args, locale);
                }
                catch (NoSuchMessageException ex) {
                    LOGGER.warn("No such Message: [{}] and [{}]", (Object)code, (Object)fallbackCode);
                }
            }
            if (defaultMessage != null) {
                return defaultMessage;
            }
            if (args != null && args.length > 0) {
                return code + ", with args: " + Arrays.toString(args);
            }
            return code;
        }
    }

    private String resolveMessageCode(MessageSource messageSource, String code, Object[] args, Locale locale) {
        try {
            return messageSource.getMessage(code, args, locale);
        }
        catch (NoSuchMessageException e) {
            LOGGER.warn("No such Message: [{}]", (Object)code);
            return null;
        }
    }

    private String resolveMessageCode(MessageSource messageSource, MessageSourceResolvable messageSourceResolvable, Locale locale) {
        Assert.notNull((Object)messageSourceResolvable, (String)"messageSourceResolvable must not be null");
        try {
            return messageSource.getMessage(messageSourceResolvable, locale);
        }
        catch (NoSuchMessageException e) {
            if (messageSourceResolvable.getDefaultMessage() != null) {
                return messageSourceResolvable.getDefaultMessage();
            }
            Object[] args = messageSourceResolvable.getArguments();
            Object[] codes = messageSourceResolvable.getCodes();
            Assert.notEmpty((Object[])codes, (String)"The codes of messageSourceResolvable must not be empty");
            Object code = codes[codes.length - 1];
            if (args != null && args.length > 0) {
                return (String)code + ", with args: " + Arrays.toString(args);
            }
            return code;
        }
    }
}

