/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common;

import java.net.InetAddress;
import org.slf4j.MDC;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class SystemProperties
implements InitializingBean,
EnvironmentAware {
    private String systemCode;
    private String systemName;
    private String systemDesc;
    private String hostName = "LocalHost";
    private String hostAddress = "127.0.0.1";
    private transient Environment environment;

    public String getSystemCode() {
        return this.systemCode;
    }

    public void setSystemCode(String systemCode) {
        this.systemCode = systemCode;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getSystemDesc() {
        return this.systemDesc;
    }

    public void setSystemDesc(String systemDesc) {
        this.systemDesc = systemDesc;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.systemCode, (String)"systemCode is required, 8 bits number.");
        if (this.systemName == null) {
            this.systemName = this.environment.getProperty("spring.application.name", this.systemCode);
        }
        if (this.systemDesc == null) {
            this.systemDesc = this.systemCode;
        }
        InetAddress localInetAddress = InetAddress.getLocalHost();
        this.hostName = localInetAddress.getHostName();
        this.hostAddress = localInetAddress.getHostAddress();
        MDC.put((String)"hostName", (String)this.hostName);
        MDC.put((String)"hostAddress", (String)this.hostAddress);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

