/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.cache;

import com.cntaiping.ec.cloud.common.cache.CacheKey;
import com.cntaiping.ec.cloud.common.cache.CacheKeyPrefix;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public interface CacheDefinition<V> {
    public static final Logger logger = LoggerFactory.getLogger(CacheDefinition.class);
    public static final String BEAN_SUFFIX = "CacheDefinition";
    public static final Long INIT_INCREMENT_VALUE = 1L;
    public static final String DEFAULT_PREFIX = "TP_";
    public static final Duration DEFAULT_TTL = Duration.ofMinutes(5L);
    public static final Long EXPIRE_TIME_VALUE = 0L;
    public static final boolean DEFAULT_USE_PREFIX = true;

    default public String getBeanSuffix() {
        return BEAN_SUFFIX;
    }

    public String getCacheName();

    default public String getKeyPrefix() {
        return DEFAULT_PREFIX;
    }

    default public CacheKeyPrefix getCacheKeyPrefix() {
        return CacheKeyPrefix.prefixed(this.getKeyPrefix());
    }

    default public boolean usePrefix() {
        return true;
    }

    default public String createCacheKey(Object ... key) {
        String cacheKey = CacheKey.simple(key).getValue();
        if (!this.usePrefix()) {
            logger.debug("Completed CacheKey==>[{}]", (Object)cacheKey);
            return cacheKey;
        }
        cacheKey = this.getCacheKeyPrefix().compute(this.getCacheName()) + cacheKey;
        logger.debug("Completed CacheKey==>[{}]", (Object)cacheKey);
        return cacheKey;
    }

    default public Duration getTtl() {
        return DEFAULT_TTL;
    }

    public void set(CacheKey var1, V var2);

    @Nullable
    public Boolean setIfAbsent(CacheKey var1, V var2);

    @Nullable
    public Boolean setIfPresent(CacheKey var1, V var2);

    @Nullable
    public Boolean hasKey(Object ... var1);

    @Nullable
    public V get(Object ... var1);

    public Boolean verify(CacheKey var1, V var2);

    @Nullable
    public Boolean delete(Object ... var1);

    @Nullable
    public Long increment(Object ... var1);

    @Nullable
    public Long decrement(Object ... var1);

    @Nullable
    public Boolean expire(Object ... var1);

    @Nullable
    public Boolean expire(CacheKey var1, Duration var2);

    @Nullable
    public Boolean expireAt(CacheKey var1, Date var2);

    @Nullable
    public Boolean expireAt(CacheKey var1, Instant var2);

    @Nullable
    public Boolean persist(Object ... var1);

    @Nullable
    public Long getExpire(Object ... var1);

    @Nullable
    public Long getExpire(CacheKey var1, TimeUnit var2);
}

