/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.cache;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public interface CacheKey {
    public static final String SEPARATOR = "::";

    public String getValue();

    public static CacheKey simple(Object ... key) {
        return new SimpleCacheKey(key);
    }

    public static class SimpleCacheKey
    implements CacheKey {
        private static final String EMPTY_KEY = "Simple";
        private static final String PREFIX = "";
        private static final String SUFFIX = "";
        private final Object[] key;
        private ConversionService conversionService = new DefaultFormattingConversionService();

        public SimpleCacheKey(Object[] key) {
            this.key = key;
        }

        public SimpleCacheKey(Object[] key, ConversionService conversionService) {
            this.key = key;
            this.conversionService = conversionService;
        }

        protected String convertKey(Object key) {
            if (key instanceof String) {
                return (String)key;
            }
            TypeDescriptor source = TypeDescriptor.forObject((Object)key);
            if (this.conversionService.canConvert(source, TypeDescriptor.valueOf(String.class))) {
                try {
                    return (String)this.conversionService.convert(key, String.class);
                }
                catch (ConversionFailedException e) {
                    if (this.isCollectionLikeOrMap(source)) {
                        return this.convertCollectionLikeOrMapKey(key, source);
                    }
                    throw e;
                }
            }
            Method toString = ReflectionUtils.findMethod(key.getClass(), (String)"toString");
            if (toString != null && !Object.class.equals(toString.getDeclaringClass())) {
                return key.toString();
            }
            throw new IllegalStateException(String.format("Cannot convert cache key %s to String. Please register a suitable Converter via 'RedisCacheConfiguration.configureKeyConverters(...)' or override '%s.toString()'.", source, key.getClass().getSimpleName()));
        }

        private String convertCollectionLikeOrMapKey(Object key, TypeDescriptor source) {
            if (source.isMap()) {
                StringBuilder target = new StringBuilder("{");
                for (Map.Entry entry : ((Map)key).entrySet()) {
                    target.append(this.convertKey(entry.getKey())).append("=").append(this.convertKey(entry.getValue()));
                }
                target.append("}");
                return target.toString();
            }
            if (source.isCollection() || source.isArray()) {
                StringJoiner sj = new StringJoiner(",");
                List<Object> collection = source.isCollection() ? (List<Object>)key : Arrays.asList(ObjectUtils.toObjectArray((Object)key));
                for (Object e : collection) {
                    sj.add(this.convertKey(e));
                }
                return "[" + sj.toString() + "]";
            }
            throw new IllegalArgumentException(String.format("Cannot convert cache key %s to String.", key));
        }

        private boolean isCollectionLikeOrMap(TypeDescriptor source) {
            return source.isArray() || source.isCollection() || source.isMap();
        }

        @Override
        public String getValue() {
            if (this.key == null) {
                return EMPTY_KEY;
            }
            String cacheKey = Arrays.stream(this.key).filter(Objects::nonNull).map(this::convertKey).collect(Collectors.joining(CacheKey.SEPARATOR, "", ""));
            return StringUtils.hasText((String)cacheKey) ? cacheKey : EMPTY_KEY;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

