/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.cache.redis;

import com.cntaiping.ec.cloud.common.cache.redis.RedisCacheDefinition;
import java.time.Duration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractRedisCacheDefinition<V>
implements RedisCacheDefinition<V>,
InitializingBean {
    @Autowired(required=false)
    @Qualifier(value="genericRedisTemplate")
    private RedisTemplate<String, V> redisTemplate;
    @Autowired(required=false)
    private CacheProperties cacheProperties;

    @Override
    public String getKeyPrefix() {
        String keyPrefix = null;
        if (this.cacheProperties != null) {
            keyPrefix = this.cacheProperties.getRedis().getKeyPrefix();
        }
        if (StringUtils.hasText(keyPrefix)) {
            return keyPrefix;
        }
        return "TP_";
    }

    @Override
    public boolean usePrefix() {
        if (this.cacheProperties != null) {
            return this.cacheProperties.getRedis().isUseKeyPrefix();
        }
        return true;
    }

    @Override
    public Duration getTtl() {
        Duration ttl = null;
        if (this.cacheProperties != null) {
            ttl = this.cacheProperties.getRedis().getTimeToLive();
        }
        if (ttl != null) {
            return ttl;
        }
        return DEFAULT_TTL;
    }

    @Override
    public String getCacheName() {
        return this.getClass().getSimpleName().replace(this.getBeanSuffix(), "");
    }

    @Override
    public RedisTemplate<String, V> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate<String, V> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.redisTemplate, (String)"RedisTemplate must not be null.");
        Assert.isTrue((boolean)this.getClass().getSimpleName().endsWith(this.getBeanSuffix()), (String)("Bean [" + this.getClass().getSimpleName() + "] not end with [" + this.getBeanSuffix() + "]."));
    }
}

