/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.cache.redis;

import com.cntaiping.ec.cloud.common.cache.CacheDefinition;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.cache.RedisCacheManagerBuilderCustomizer;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;

public class CacheDefinitionRedisCacheManagerBuilderCustomizer
implements RedisCacheManagerBuilderCustomizer {
    private final ObjectProvider<CacheDefinition<?>> cacheDefinitions;
    private final RedisSerializer<String> keySerializer;
    private final RedisSerializer<Object> valueSerializer;

    public CacheDefinitionRedisCacheManagerBuilderCustomizer(ObjectProvider<CacheDefinition<?>> cacheDefinitions, RedisSerializer<String> keySerializer, RedisSerializer<Object> valueSerializer) {
        this.cacheDefinitions = cacheDefinitions;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public void customize(RedisCacheManager.RedisCacheManagerBuilder builder) {
        this.cacheDefinitions.orderedStream().forEach(cacheDefinition -> {
            RedisCacheConfiguration redisCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
            redisCacheConfiguration = !cacheDefinition.usePrefix() ? redisCacheConfiguration.disableKeyPrefix() : redisCacheConfiguration.prefixCacheNameWith(cacheDefinition.getKeyPrefix());
            redisCacheConfiguration = redisCacheConfiguration.entryTtl(cacheDefinition.getTtl()).serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer(this.keySerializer)).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(this.valueSerializer));
            builder.withCacheConfiguration(cacheDefinition.getCacheName(), redisCacheConfiguration);
        });
    }
}

