/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.cache.redis;

import com.cntaiping.ec.cloud.common.cache.CacheDefinition;
import com.cntaiping.ec.cloud.common.cache.CacheKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.BoundGeoOperations;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.BoundStreamOperations;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.BoundZSetOperations;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisCacheDefinition<V>
extends CacheDefinition<V> {
    public RedisTemplate<String, V> getRedisTemplate();

    @Override
    default public void set(CacheKey cacheKey, V value) {
        this.getRedisTemplate().boundValueOps((Object)this.createCacheKey(cacheKey.getValue())).set(value, this.getTtl());
    }

    @Override
    @Nullable
    default public Boolean setIfAbsent(CacheKey cacheKey, V value) {
        return this.getRedisTemplate().boundValueOps((Object)this.createCacheKey(cacheKey.getValue())).setIfAbsent(value, this.getTtl());
    }

    @Override
    @Nullable
    default public Boolean setIfPresent(CacheKey cacheKey, V value) {
        return this.getRedisTemplate().boundValueOps((Object)this.createCacheKey(cacheKey.getValue())).setIfPresent(value, this.getTtl());
    }

    @Override
    @Nullable
    default public Boolean hasKey(Object ... key) {
        return this.getRedisTemplate().hasKey((Object)this.createCacheKey(key));
    }

    @Override
    @Nullable
    default public V get(Object ... key) {
        return (V)this.getRedisTemplate().boundValueOps((Object)this.createCacheKey(key)).get();
    }

    @Override
    default public Boolean verify(CacheKey cacheKey, V expected) {
        Object actual = this.getRedisTemplate().boundValueOps((Object)this.createCacheKey(cacheKey.getValue())).get();
        return expected == null && actual == null || expected != null && expected.equals(actual);
    }

    @Override
    @Nullable
    default public Boolean delete(Object ... key) {
        return this.getRedisTemplate().delete((Object)this.createCacheKey(key));
    }

    @Override
    @Nullable
    default public Long increment(Object ... key) {
        String cacheKey = this.createCacheKey(key);
        Long increment = this.getRedisTemplate().boundValueOps((Object)cacheKey).increment();
        if (INIT_INCREMENT_VALUE.equals(increment)) {
            this.expire(key);
        }
        return increment;
    }

    @Override
    @Nullable
    default public Long decrement(Object ... key) {
        return this.getRedisTemplate().boundValueOps((Object)this.createCacheKey(key)).decrement();
    }

    @Override
    @Nullable
    default public Boolean expire(Object ... key) {
        return this.getRedisTemplate().expire((Object)this.createCacheKey(key), this.getTtl());
    }

    @Override
    @Nullable
    default public Boolean expire(CacheKey cacheKey, Duration timeout) {
        return this.getRedisTemplate().expire((Object)this.createCacheKey(cacheKey.getValue()), timeout);
    }

    @Override
    @Nullable
    default public Boolean expireAt(CacheKey cacheKey, Date date) {
        return this.getRedisTemplate().expireAt((Object)this.createCacheKey(cacheKey.getValue()), date);
    }

    @Override
    @Nullable
    default public Boolean expireAt(CacheKey cacheKey, Instant expireAt) {
        Assert.notNull((Object)expireAt, (String)"Timestamp must not be null");
        return this.expireAt(cacheKey, Date.from(expireAt));
    }

    @Override
    @Nullable
    default public Boolean persist(Object ... key) {
        return this.getRedisTemplate().persist((Object)this.createCacheKey(key));
    }

    @Override
    @Nullable
    default public Long getExpire(Object ... key) {
        return this.getRedisTemplate().getExpire((Object)this.createCacheKey(key));
    }

    @Override
    @Nullable
    default public Long getExpire(CacheKey cacheKey, TimeUnit timeUnit) {
        return this.getRedisTemplate().getExpire((Object)this.createCacheKey(cacheKey.getValue()), timeUnit);
    }

    default public BoundValueOperations<String, V> boundValueOps(Object ... key) {
        BoundValueOperations boundValueOps = this.getRedisTemplate().boundValueOps((Object)this.createCacheKey(key));
        this.setExpirationTime(key);
        return boundValueOps;
    }

    default public BoundGeoOperations<String, V> boundGeoOps(Object ... key) {
        BoundGeoOperations boundGeoOps = this.getRedisTemplate().boundGeoOps((Object)this.createCacheKey(key));
        this.setExpirationTime(key);
        return boundGeoOps;
    }

    default public <HK, HV> BoundHashOperations<String, HK, HV> boundHashOps(Object ... key) {
        BoundHashOperations boundHashOps = this.getRedisTemplate().boundHashOps((Object)this.createCacheKey(key));
        this.setExpirationTime(key);
        return boundHashOps;
    }

    default public BoundListOperations<String, V> boundListOps(Object ... key) {
        BoundListOperations boundListOps = this.getRedisTemplate().boundListOps((Object)this.createCacheKey(key));
        this.setExpirationTime(key);
        return boundListOps;
    }

    default public BoundSetOperations<String, V> boundSetOps(Object ... key) {
        BoundSetOperations boundSetOps = this.getRedisTemplate().boundSetOps((Object)this.createCacheKey(key));
        this.setExpirationTime(key);
        return boundSetOps;
    }

    default public <HK, HV> BoundStreamOperations<String, HK, HV> boundStreamOps(Object ... key) {
        BoundStreamOperations boundStreamOps = this.getRedisTemplate().boundStreamOps((Object)this.createCacheKey(key));
        this.setExpirationTime(key);
        return boundStreamOps;
    }

    default public BoundZSetOperations<String, V> boundZSetOps(Object ... key) {
        BoundZSetOperations boundZSetOps = this.getRedisTemplate().boundZSetOps((Object)this.createCacheKey(key));
        this.setExpirationTime(key);
        return boundZSetOps;
    }

    default public HyperLogLogOperations<String, V> opsForHyperLogLog() {
        return this.getRedisTemplate().opsForHyperLogLog();
    }

    default public void setExpirationTime(Object ... key) {
        String cacheKey = this.createCacheKey(key);
        Long expire = this.getRedisTemplate().getExpire((Object)cacheKey);
        if (expire == null || expire.compareTo(EXPIRE_TIME_VALUE) <= 0) {
            logger.debug("Set the expiration time [{}] for the cache key[{}]", (Object)this.getTtl(), (Object)cacheKey);
            this.getRedisTemplate().expire((Object)cacheKey, this.getTtl());
        }
    }
}

