/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.channel.http.interceptor;

import com.cntaiping.ec.cloud.common.core.Context;
import com.cntaiping.ec.cloud.common.core.ContextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class AbstractPayloadHandlerInterceptor
extends HandlerInterceptorAdapter {
    protected Logger logger = LoggerFactory.getLogger(AbstractPayloadHandlerInterceptor.class);
    protected List<MediaType> mediaTypes = new ArrayList<MediaType>();

    protected abstract Map<String, Object> parseForm(HttpServletRequest var1);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.isSupportedMediaType(request.getContentType())) {
            this.logger.debug("The current ContentType [{}] is not supported", (Object)request.getContentType());
            return true;
        }
        Map<String, Object> dataMap = this.parseForm(request);
        Context context = ContextUtils.get();
        if (context != null) {
            context.setDataMap(dataMap);
            context.setAttribute("x-parameters", dataMap);
        }
        return true;
    }

    protected boolean isSupportedMediaType(String contentType) {
        try {
            if (contentType == null) {
                return false;
            }
            MediaType parseMediaType = MediaType.parseMediaType((String)contentType);
            for (MediaType mediaType : this.mediaTypes) {
                if (!mediaType.isCompatibleWith(parseMediaType)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.logger.warn("An error occurred while checking whether the current ContentType [{}] is supported.==>[{}]", new Object[]{contentType, this.mediaTypes, e});
            return false;
        }
        return false;
    }

    public List<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<MediaType> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }
}

