/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.channel.http.interceptor;

import com.cntaiping.ec.cloud.common.channel.http.processor.ContextProcessor;
import com.cntaiping.ec.cloud.common.core.Context;
import com.cntaiping.ec.cloud.common.core.ContextUtils;
import com.cntaiping.ec.cloud.common.core.DefaultContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ContextHandlerInterceptor
extends HandlerInterceptorAdapter {
    private ContextProcessor contextProcessor;

    public ContextHandlerInterceptor(ContextProcessor contextProcessor) {
        this.contextProcessor = contextProcessor;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        DefaultContext context = new DefaultContext();
        context.setAttribute("x-channel-type", "http");
        context.setLocale(request.getLocale());
        if (this.contextProcessor != null) {
            this.contextProcessor.resolveAttribute(context, request);
        }
        ContextUtils.set(context);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable ModelAndView modelAndView) throws Exception {
        Context context = ContextUtils.get();
        if (this.contextProcessor != null) {
            this.contextProcessor.postAttributes(context, request, response);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        ContextUtils.remove();
    }

    public void afterConcurrentHandlingStarted(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ContextUtils.remove();
    }

    public void setContextProcessor(ContextProcessor contextProcessor) {
        this.contextProcessor = contextProcessor;
    }
}

