/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.channel.http.interceptor;

import com.cntaiping.ec.cloud.common.SystemProperties;
import com.cntaiping.ec.cloud.common.core.Context;
import com.cntaiping.ec.cloud.common.core.ContextUtils;
import com.cntaiping.ec.cloud.common.exception.ExceptionUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RequestTracingHandlerInterceptor
extends HandlerInterceptorAdapter {
    private static Logger logger = LoggerFactory.getLogger((String)"requestTracing");
    private static final String TIMING = "service.timing";
    private static final String REQUEST_ID = "requestId";
    private static final String START_TIME = "startTime";
    private static final String TRACE_NO = "traceNo";
    private static final String HOST_NAME = "hostName";
    private static final String HOST_ADDRESS = "hostAddress";
    private static final String SYSTEM_CODE = "systemCode";
    private static final String SYSTEM_NAME = "systemName";
    private static final String ENDPOINT = "endpoint";
    private static final String CHANNEL = "channel";
    private static final String CHANNEL_TYPE = "channelType";
    private static final String SESSION_ID = "sessionId";
    private static final String SOURCE = "source";
    private static final String SUCCESS = "success";
    private static final String RET_CODE = "retCode";
    private SystemProperties systemProperties;

    public RequestTracingHandlerInterceptor(SystemProperties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Context context;
        this.putMDC(SYSTEM_CODE, this.systemProperties.getSystemCode());
        this.putMDC(SYSTEM_NAME, this.systemProperties.getSystemName());
        MDC.put((String)START_TIME, (String)String.valueOf(System.currentTimeMillis()));
        if (MDC.get((String)HOST_NAME) == null) {
            this.putMDC(HOST_NAME, this.systemProperties.getHostName());
            this.putMDC(HOST_ADDRESS, this.systemProperties.getHostAddress());
        }
        if ((context = ContextUtils.get()) != null) {
            this.putMDC(ENDPOINT, context.getEndpoint());
            this.putMDC(CHANNEL, (String)context.getAttribute("x-channel"));
            this.putMDC(CHANNEL_TYPE, (String)context.getAttribute("x-channel-type"));
            this.putMDC(SESSION_ID, context.getSessionId());
            this.putMDC(REQUEST_ID, context.getRequestId());
            this.putMDC(TRACE_NO, context.getTraceNo());
            this.putMDC(SOURCE, (String)context.getAttribute("x-source"));
        }
        return true;
    }

    private void putMDC(String key, String value) {
        if (value != null) {
            MDC.put((String)key, (String)(key + ":" + value));
        } else {
            MDC.put((String)key, (String)(key + ":NA"));
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, @Nullable Exception ex) throws Exception {
        String startTimeStr = MDC.get((String)START_TIME);
        if (startTimeStr != null) {
            long startTime = Long.parseLong(startTimeStr);
            long endTime = System.currentTimeMillis();
            this.putMDC(TIMING, String.valueOf(endTime - startTime));
        }
        boolean success = true;
        String retCode = "0000";
        if (ex != null) {
            success = false;
            retCode = this.getRetCode(ex);
        }
        this.putMDC(SUCCESS, String.valueOf(success));
        this.putMDC(RET_CODE, retCode);
        logger.info("");
    }

    private String getRetCode(Exception ex) {
        MessageSourceResolvable messagesourceresolvable;
        String[] codes;
        Throwable th = ExceptionUtil.unwrapThrowable(ex);
        if (th instanceof MessageSourceResolvable && (codes = (messagesourceresolvable = (MessageSourceResolvable)th).getCodes()) != null && codes.length > 0) {
            return codes[0];
        }
        return th.getClass().getSimpleName();
    }
}

