/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.channel.http.processor;

import com.cntaiping.ec.cloud.common.channel.CertificationResolver;
import com.cntaiping.ec.cloud.common.channel.ChannelResolver;
import com.cntaiping.ec.cloud.common.channel.EndpointResolver;
import com.cntaiping.ec.cloud.common.channel.PrincipalResolver;
import com.cntaiping.ec.cloud.common.channel.RefererResolver;
import com.cntaiping.ec.cloud.common.channel.RequestIdResolver;
import com.cntaiping.ec.cloud.common.channel.SessionIdResolver;
import com.cntaiping.ec.cloud.common.channel.SourceResolver;
import com.cntaiping.ec.cloud.common.channel.TokenResolver;
import com.cntaiping.ec.cloud.common.channel.TraceNoResolver;
import com.cntaiping.ec.cloud.common.channel.UserAgentResolver;
import com.cntaiping.ec.cloud.common.channel.http.processor.ContextProcessor;
import com.cntaiping.ec.cloud.common.core.Context;
import com.cntaiping.ec.cloud.common.utils.id.UUID62;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class DefaultContextProcessor
implements ContextProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultContextProcessor.class);
    private ObjectProvider<RequestIdResolver<HttpServletRequest>> requestIdResolvers;
    private ObjectProvider<TraceNoResolver<HttpServletRequest>> traceNoResolvers;
    private ObjectProvider<ChannelResolver<HttpServletRequest>> channelResolvers;
    private ObjectProvider<SourceResolver<HttpServletRequest>> sourceResolvers;
    private ObjectProvider<TokenResolver<HttpServletRequest, HttpServletResponse>> tokenResolvers;
    private ObjectProvider<PrincipalResolver<HttpServletRequest>> principalResolvers;
    private ObjectProvider<CertificationResolver<HttpServletRequest>> certificationResolvers;
    private ObjectProvider<EndpointResolver<HttpServletRequest>> endpointResolvers;
    private ObjectProvider<SessionIdResolver<HttpServletRequest, HttpServletResponse>> sessionIdResolvers;
    private ObjectProvider<RefererResolver<HttpServletRequest>> refererResolvers;
    private ObjectProvider<UserAgentResolver<HttpServletRequest>> userAgentResolvers;

    @Override
    public void resolveAttribute(Context context, HttpServletRequest request) {
        this.resolveEndpoint(context, request);
        this.resolveRequestId(context, request);
        this.resolveTraceNo(context, request);
        this.resolveChannel(context, request);
        this.resolveSource(context, request);
        this.resolveToken(context, request);
        this.resolvePrincipal(context, request);
        this.resolveCertification(context, request);
        this.resolveSessionId(context, request);
        this.resolveReferer(context, request);
        this.resolveUserAgent(context, request);
    }

    @Override
    public void postAttributes(Context context, HttpServletRequest request, HttpServletResponse response) {
        if (context.getSessionId() != null) {
            this.setSessionId(context, request, response);
        }
        if (context.getAttribute("x-token") != null) {
            this.setToken(context, request, response);
        }
    }

    protected void resolveEndpoint(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolveEndpoint");
        Optional<EndpointResolver> optional = this.endpointResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolveEndpoint(request) != null).findFirst();
        optional.ifPresent(resolver -> {
            String endpoint = resolver.resolveEndpoint(request);
            context.setEndpoint(endpoint);
            context.setAttribute("x-request-uri", endpoint);
        });
    }

    protected void resolveRequestId(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolveRequestId");
        Optional<RequestIdResolver> optional = this.requestIdResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolveRequestId(request) != null).findFirst();
        String requestId = optional.map(resolver -> resolver.resolveRequestId(request)).orElse(UUID62.randomUUID62());
        context.setRequestId(requestId);
    }

    protected void resolveTraceNo(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolveTraceNo");
        Optional<TraceNoResolver> optional = this.traceNoResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolveTraceNo(request) != null).findFirst();
        String traceNo = optional.map(resolver -> resolver.resolveTraceNo(request)).orElse(UUID62.randomUUID62());
        context.setTraceNo(traceNo);
        context.setAttribute("x-trace-no", traceNo);
    }

    protected void resolveChannel(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolveChannel");
        Optional<ChannelResolver> optional = this.channelResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolveChannel(request) != null).findFirst();
        optional.ifPresent(resolver -> context.setAttribute("x-channel", resolver.resolveChannel(request)));
    }

    protected void resolveSource(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolveSource");
        Optional<SourceResolver> optional = this.sourceResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolveSource(request) != null).findFirst();
        optional.ifPresent(resolver -> context.setAttribute("x-source", resolver.resolveSource(request)));
    }

    protected void resolveToken(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolveToken");
        Optional<TokenResolver> optional = this.tokenResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolveToken(request) != null).findFirst();
        optional.ifPresent(resolver -> context.setAttribute("x-token", resolver.resolveToken(request)));
    }

    protected void resolvePrincipal(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolvePrincipal");
        Optional<PrincipalResolver> optional = this.principalResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolvePrincipal(request) != null).findFirst();
        optional.ifPresent(resolver -> context.setAttribute("x-principal", resolver.resolvePrincipal(request)));
    }

    protected void resolveCertification(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolveCertification");
        Optional<CertificationResolver> optional = this.certificationResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolveCertification(request) != null).findFirst();
        optional.ifPresent(resolver -> context.setAttribute("x-certification", resolver.resolveCertification(request)));
    }

    protected void resolveSessionId(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolveSessionId");
        Optional<SessionIdResolver> optional = this.sessionIdResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolveSessionId(request) != null).findFirst();
        optional.ifPresent(resolver -> context.setSessionId(resolver.resolveSessionId(request)));
    }

    protected void resolveReferer(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolveReferer");
        Optional<RefererResolver> optional = this.refererResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolveReferer(request) != null).findFirst();
        optional.ifPresent(resolver -> context.setAttribute("x-referer", resolver.resolveReferer(request)));
    }

    protected void resolveUserAgent(Context context, HttpServletRequest request) {
        LOGGER.trace("====>executing DefaultContextProcessor#resolveUserAgent");
        Optional<UserAgentResolver> optional = this.userAgentResolvers.orderedStream().filter(resolver -> resolver.support(request) && resolver.resolveUserAgent(request) != null).findFirst();
        optional.ifPresent(resolver -> context.setAttribute("x-user-agent", resolver.resolveUserAgent(request)));
    }

    protected void setSessionId(Context context, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.trace("====>executing DefaultContextProcessor#setSessionId");
        this.sessionIdResolvers.orderedStream().filter(resolver -> resolver.support(request)).forEach(resolver -> resolver.setSessionId(request, response, context.getSessionId()));
    }

    protected void setToken(Context context, HttpServletRequest request, HttpServletResponse response) {
        LOGGER.trace("====>executing DefaultContextProcessor#setToken");
        this.tokenResolvers.orderedStream().filter(resolver -> resolver.support(request)).forEach(resolver -> resolver.setToken(request, response, (String)context.getAttribute("x-token")));
    }

    public void setRequestIdResolvers(ObjectProvider<RequestIdResolver<HttpServletRequest>> requestIdResolvers) {
        this.requestIdResolvers = requestIdResolvers;
    }

    public void setTraceNoResolvers(ObjectProvider<TraceNoResolver<HttpServletRequest>> traceNoResolvers) {
        this.traceNoResolvers = traceNoResolvers;
    }

    public void setChannelResolvers(ObjectProvider<ChannelResolver<HttpServletRequest>> channelResolvers) {
        this.channelResolvers = channelResolvers;
    }

    public void setSourceResolvers(ObjectProvider<SourceResolver<HttpServletRequest>> sourceResolvers) {
        this.sourceResolvers = sourceResolvers;
    }

    public void setTokenResolvers(ObjectProvider<TokenResolver<HttpServletRequest, HttpServletResponse>> tokenResolvers) {
        this.tokenResolvers = tokenResolvers;
    }

    public void setPrincipalResolvers(ObjectProvider<PrincipalResolver<HttpServletRequest>> principalResolvers) {
        this.principalResolvers = principalResolvers;
    }

    public void setCertificationResolvers(ObjectProvider<CertificationResolver<HttpServletRequest>> certificationResolvers) {
        this.certificationResolvers = certificationResolvers;
    }

    public void setEndpointResolvers(ObjectProvider<EndpointResolver<HttpServletRequest>> endpointResolvers) {
        this.endpointResolvers = endpointResolvers;
    }

    public void setSessionIdResolvers(ObjectProvider<SessionIdResolver<HttpServletRequest, HttpServletResponse>> sessionIdResolvers) {
        this.sessionIdResolvers = sessionIdResolvers;
    }

    public void setRefererResolvers(ObjectProvider<RefererResolver<HttpServletRequest>> refererResolvers) {
        this.refererResolvers = refererResolvers;
    }

    public void setUserAgentResolvers(ObjectProvider<UserAgentResolver<HttpServletRequest>> userAgentResolvers) {
        this.userAgentResolvers = userAgentResolvers;
    }
}

