/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.channel.http.resolver;

import com.cntaiping.ec.cloud.common.channel.SessionIdResolver;
import com.cntaiping.ec.cloud.common.channel.http.resolver.HttpResolver;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.util.StringUtils;

public class HttpCookieSessionIdResolver
extends HttpResolver
implements SessionIdResolver<HttpServletRequest, HttpServletResponse> {
    private static final String WRITTEN_SESSION_ID_ATTR = HttpCookieSessionIdResolver.class.getName().concat(".WRITTEN_SESSION_ID_ATTR");
    private final CookieSerializer cookieSerializer;
    private final String cookieName;
    private final boolean writeCookie;

    public HttpCookieSessionIdResolver(boolean writeCookie, String cookieName, CookieSerializer cookieSerializer) {
        this.writeCookie = writeCookie;
        this.cookieName = cookieName;
        this.cookieSerializer = cookieSerializer;
    }

    @Override
    public String resolveSessionId(HttpServletRequest request) {
        List cookieValues = this.cookieSerializer.readCookieValues(request);
        if (cookieValues != null && !cookieValues.isEmpty()) {
            return (String)cookieValues.get(0);
        }
        return null;
    }

    @Override
    public void setSessionId(HttpServletRequest request, HttpServletResponse response, String sessionId) {
        if (!this.writeCookie) {
            return;
        }
        if (!StringUtils.hasText((String)sessionId)) {
            return;
        }
        boolean isFound = false;
        Collection responseHeaders = response.getHeaders("Set-Cookie");
        if (responseHeaders != null) {
            for (String responseHeader : responseHeaders) {
                if (!responseHeader.contains(this.cookieName)) continue;
                isFound = true;
                break;
            }
        }
        if (sessionId.equals(request.getAttribute(WRITTEN_SESSION_ID_ATTR))) {
            isFound = true;
        }
        if (!isFound) {
            request.setAttribute(WRITTEN_SESSION_ID_ATTR, (Object)sessionId);
            this.cookieSerializer.writeCookieValue(new CookieSerializer.CookieValue(request, response, sessionId));
        }
    }

    @Override
    public void expireSession(HttpServletRequest request, HttpServletResponse response) {
        this.cookieSerializer.writeCookieValue(new CookieSerializer.CookieValue(request, response, ""));
    }
}

