/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.channel.http.resolver;

import com.cntaiping.ec.cloud.common.channel.TokenResolver;
import com.cntaiping.ec.cloud.common.channel.http.resolver.HttpResolver;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.util.StringUtils;

public class HttpCookieTokenResolver
extends HttpResolver
implements TokenResolver<HttpServletRequest, HttpServletResponse> {
    private static final String WRITTEN_TOKEN_ATTR = HttpCookieTokenResolver.class.getName().concat(".WRITTEN_TOKEN_ATTR");
    private final CookieSerializer cookieSerializer;
    private final String cookieName;
    private final boolean writeCookie;

    public HttpCookieTokenResolver(boolean writeCookie, String cookieName, CookieSerializer cookieSerializer) {
        this.writeCookie = writeCookie;
        this.cookieName = cookieName;
        this.cookieSerializer = cookieSerializer;
    }

    @Override
    public String resolveToken(HttpServletRequest request) {
        List cookieValues = this.cookieSerializer.readCookieValues(request);
        if (cookieValues != null && !cookieValues.isEmpty()) {
            return (String)cookieValues.get(0);
        }
        return null;
    }

    @Override
    public void setToken(HttpServletRequest request, HttpServletResponse response, String token) {
        if (!this.writeCookie) {
            return;
        }
        if (!StringUtils.hasText((String)token)) {
            return;
        }
        boolean isFound = false;
        Collection responseHeaders = response.getHeaders("Set-Cookie");
        if (responseHeaders != null) {
            for (String responseHeader : responseHeaders) {
                if (!responseHeader.contains(this.cookieName)) continue;
                isFound = true;
                break;
            }
        }
        if (token.equals(request.getAttribute(WRITTEN_TOKEN_ATTR))) {
            isFound = true;
        }
        if (!isFound) {
            request.setAttribute(WRITTEN_TOKEN_ATTR, (Object)token);
            this.cookieSerializer.writeCookieValue(new CookieSerializer.CookieValue(request, response, token));
        }
    }

    @Override
    public void expireToken(HttpServletRequest request, HttpServletResponse response) {
        this.cookieSerializer.writeCookieValue(new CookieSerializer.CookieValue(request, response, ""));
    }
}

