/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.channel.http.resolver;

import com.cntaiping.ec.cloud.common.channel.SourceResolver;
import com.cntaiping.ec.cloud.common.channel.http.resolver.HttpResolver;
import com.cntaiping.ec.cloud.common.utils.http.IpAddressUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public class HttpHeaderSourceResolver
extends HttpResolver
implements SourceResolver<HttpServletRequest> {
    private final List<String> headerNames;

    public HttpHeaderSourceResolver(List<String> headerNames) {
        this.headerNames = headerNames;
    }

    @Override
    public String resolveSource(HttpServletRequest request) {
        for (String headerName : this.headerNames) {
            String headerValue = request.getHeader(headerName);
            if (!StringUtils.hasText((String)headerValue)) continue;
            return headerValue;
        }
        return IpAddressUtils.getIpAddress(request);
    }
}

