/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.channel.http.resolver;

import com.cntaiping.ec.cloud.common.channel.TokenResolver;
import com.cntaiping.ec.cloud.common.channel.http.resolver.HttpResolver;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class HttpHeaderTokenResolver
extends HttpResolver
implements TokenResolver<HttpServletRequest, HttpServletResponse> {
    private final List<String> headerNames;
    private final boolean isSetResponseHeader;

    public HttpHeaderTokenResolver(boolean isSetResponseHeader, List<String> headerNames) {
        this.isSetResponseHeader = isSetResponseHeader;
        this.headerNames = headerNames;
    }

    @Override
    public String resolveToken(HttpServletRequest request) {
        for (String headerName : this.headerNames) {
            String headerValue = request.getHeader(headerName);
            if (!StringUtils.hasText((String)headerValue)) continue;
            return headerValue;
        }
        return null;
    }

    @Override
    public void setToken(HttpServletRequest request, HttpServletResponse response, String token) {
        if (!this.isSetResponseHeader) {
            return;
        }
        for (String headerName : this.headerNames) {
            String responseHeader = response.getHeader(headerName);
            if (responseHeader != null) continue;
            response.setHeader(headerName, token);
        }
    }

    @Override
    public void expireToken(HttpServletRequest request, HttpServletResponse response) {
        for (String headerName : this.headerNames) {
            response.setHeader(headerName, "");
        }
    }
}

