/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.channel.http.resolver;

import com.cntaiping.ec.cloud.common.channel.SessionIdResolver;
import com.cntaiping.ec.cloud.common.channel.http.resolver.HttpResolver;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class HttpParameterSessionIdResolver
extends HttpResolver
implements SessionIdResolver<HttpServletRequest, HttpServletResponse> {
    private final List<String> parameterNames;

    public HttpParameterSessionIdResolver(List<String> parameterNames) {
        this.parameterNames = parameterNames;
    }

    @Override
    public String resolveSessionId(HttpServletRequest request) {
        for (String name : this.parameterNames) {
            String value = request.getParameter(name);
            if (!StringUtils.hasText((String)value)) continue;
            return value;
        }
        return null;
    }

    @Override
    public void setSessionId(HttpServletRequest request, HttpServletResponse response, String sessionId) {
    }

    @Override
    public void expireSession(HttpServletRequest request, HttpServletResponse response) {
    }
}

