/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.core;

import com.cntaiping.ec.cloud.common.core.Context;
import com.cntaiping.ec.cloud.common.core.User;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DefaultContext
implements Context,
Serializable {
    private static final long serialVersionUID = 1L;
    private String requestId;
    private String traceNo;
    private String sessionId;
    private String endpoint;
    private final long timestamp = System.currentTimeMillis();
    private Locale locale = Locale.getDefault();
    private User user;
    private String state = "";
    private final HashMap<String, Object> dataMap = new HashMap(7);
    private final HashMap<String, Object> requestMap = new HashMap(3);
    private final HashMap<String, Object> sessionMap = new HashMap(3);
    private final transient HashMap<String, Object> variableMap = new HashMap(3);

    @Override
    public String getTraceNo() {
        return this.traceNo;
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    public <T extends User> T getUser() {
        return (T)this.user;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public <T> T getData(String name) {
        return (T)this.dataMap.get(name);
    }

    @Override
    public Map<String, Object> getDataMap() {
        return new HashMap<String, Object>(this.dataMap);
    }

    @Override
    public Map<String, Object> getDataMapDirectly() {
        return this.dataMap;
    }

    @Override
    public <T> T getVariable(String name) {
        return (T)this.variableMap.get(name);
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variableMap;
    }

    @Override
    public <T> T getAttribute(String name) {
        return (T)this.requestMap.get(name);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.requestMap);
    }

    @Override
    public <T> T getSessionAttribute(String name) {
        return (T)this.sessionMap.get(name);
    }

    @Override
    public Map<String, Object> getSessionAttributes() {
        return Collections.unmodifiableMap(this.sessionMap);
    }

    @Override
    public void setTraceNo(String traceNo) {
        this.traceNo = traceNo;
    }

    @Override
    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    @Override
    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void setVariable(String name, Object value) {
        this.variableMap.put(name, value);
    }

    @Override
    public void setVariables(Map<String, Object> variables) {
        this.variableMap.putAll(variables);
    }

    @Override
    public void setData(String name, Object value) {
        this.dataMap.put(name, value);
    }

    @Override
    public void setDataMap(Map<String, Object> dataMap) {
        this.dataMap.putAll(dataMap);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.requestMap.put(name, value);
    }

    @Override
    public void setSessionAttribute(String name, Object value) {
        this.sessionMap.put(name, value);
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    public String toString() {
        HashMap<String, Object> request;
        Map rawData;
        StringBuilder builder = new StringBuilder("context[");
        builder.append("endpoint=").append(this.endpoint).append(", ");
        if (this.state != null && this.state.length() > 0) {
            builder.append("state=").append(this.state).append(", ");
        }
        builder.append("locale=").append(this.locale).append(", ");
        if (this.user != null) {
            builder.append("user=").append(this.user.getUniqueId()).append(", ");
        }
        builder.append("timestamp=").append(new Timestamp(this.timestamp)).append(", ");
        if (this.sessionId != null) {
            builder.append("sessionId=").append(this.sessionId).append(", ");
        }
        if (this.requestId != null) {
            builder.append("requestId=").append(this.requestId).append(", ");
        }
        builder.append("]");
        if (this.dataMap.size() > 0) {
            builder.append("\n  ").append("dataMap: ").append(this.dataMap);
        }
        if ((rawData = (Map)(request = new HashMap<String, Object>(this.requestMap)).remove("PARAMETERS")) != null && rawData.size() > 0) {
            builder.append("\n  ").append("rawData: ").append(rawData);
        }
        if (request.size() > 0) {
            builder.append("\n  ").append("requestMap: ").append(request);
        }
        if (this.sessionMap.size() > 0) {
            builder.append("\n  ").append("sessionMap: ").append(this.sessionMap);
        }
        if (this.variableMap.size() > 0) {
            builder.append("\n  ").append("variableMap: ").append(this.variableMap);
        }
        return builder.toString();
    }
}

