/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.core;

import com.cntaiping.ec.cloud.common.core.UserEx;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class DefaultUser
implements UserEx,
Serializable {
    private static final long serialVersionUID = 1L;
    private Locale locale;
    private String cifId;
    private String userId;
    private String uniqueId;
    private String uuid;
    private String name;
    private String[] roles;
    private boolean logined = true;
    private String state;
    private final Map<String, Object> attributes = new HashMap<String, Object>(7);

    @Override
    public boolean isLogined() {
        return this.logined;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getUniqueId() {
        if (this.uniqueId == null) {
            this.uniqueId = this.cifId == null ? this.userId : this.userId + "@" + this.cifId;
        }
        return this.uniqueId;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getCifId() {
        return this.cifId;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getRoles() {
        return this.roles;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public <T> T getAttribute(String attributeName) {
        return (T)this.attributes.get(attributeName);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    @Override
    public void setCifId(String cifId) {
        this.cifId = cifId;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setRoles(String ... roles) {
        this.roles = roles;
    }

    @Override
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Override
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    @Override
    public void setLogined(boolean logined) {
        this.logined = logined;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultUser that = (DefaultUser)o;
        return Objects.equals(this.uniqueId, that.uniqueId) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.uniqueId, this.name);
    }

    public String toString() {
        return "DefaultUser{locale=" + this.locale + ", cifId='" + this.cifId + '\'' + ", userId='" + this.userId + '\'' + ", uniqueId='" + this.uniqueId + '\'' + ", uuid='" + this.uuid + '\'' + ", name='" + this.name + '\'' + ", roles=" + Arrays.toString(this.roles) + ", logined=" + this.logined + ", state='" + this.state + '\'' + ", attributes=" + this.attributes + '}';
    }
}

