/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.distributedlock.annotations;

import com.cntaiping.ec.cloud.common.distributedlock.DistributedLockFactory;
import com.cntaiping.ec.cloud.common.distributedlock.annotations.DistributedLockingConfigurer;
import com.cntaiping.ec.cloud.common.distributedlock.annotations.EnableDistributedLocking;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.KeyGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

@Configuration
public class AbstractDistributedLockingConfiguration
implements ImportAware {
    @Nullable
    protected AnnotationAttributes enableDistributedLocking;
    @Nullable
    protected Supplier<DistributedLockFactory> distributedLockFactory;
    @Nullable
    protected Supplier<KeyGenerator> keyGenerator;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.enableDistributedLocking = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableDistributedLocking.class.getName(), false));
        if (this.enableDistributedLocking == null) {
            throw new IllegalArgumentException("@EnableDistributedLocking is not present on importing class " + importMetadata.getClassName());
        }
    }

    @Autowired(required=false)
    void setConfigurers(Collection<DistributedLockingConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException(configurers.size() + " implementations of DistributedLockingConfigurer were found when only 1 was expected. Refactor the configuration such that DistributedLockingConfigurer is implemented only once or not at all.");
        }
        DistributedLockingConfigurer configurer = configurers.iterator().next();
        this.useDistributedLockingConfigurer(configurer);
    }

    protected void useDistributedLockingConfigurer(DistributedLockingConfigurer config) {
        this.distributedLockFactory = config::distributedLockFactory;
        this.keyGenerator = config::keyGenerator;
    }
}

