/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.distributedlock.interceptor;

import com.cntaiping.ec.cloud.common.distributedlock.interceptor.DistributedLockOperation;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.DistributedLockOperationSource;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.MethodClassKey;
import org.springframework.lang.Nullable;

public abstract class AbstractFallbackDistributedLockOperationSource
implements DistributedLockOperationSource {
    private static final DistributedLockOperation NULL_DISTRIBUTEDLOCK_ATTRIBUTE = DistributedLockOperation.builder().build();
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Map<Object, DistributedLockOperation> attributeDistributedLock = new ConcurrentHashMap<Object, DistributedLockOperation>(1024);

    @Override
    @Nullable
    public DistributedLockOperation getDistributedLockOperation(Method method, @Nullable Class<?> targetClass) {
        if (method.getDeclaringClass() == Object.class) {
            return null;
        }
        Object distributedLockKey = this.getDistributedLockKey(method, targetClass);
        DistributedLockOperation cached = this.attributeDistributedLock.get(distributedLockKey);
        if (cached != null) {
            return cached != NULL_DISTRIBUTEDLOCK_ATTRIBUTE ? cached : null;
        }
        DistributedLockOperation distributedLockOp = this.computeDistributedLockOperation(method, targetClass);
        if (distributedLockOp != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Adding distributedLockable method '" + method.getName() + "' with attribute: " + distributedLockOp));
            }
            this.attributeDistributedLock.put(distributedLockKey, distributedLockOp);
        } else {
            this.attributeDistributedLock.put(distributedLockKey, NULL_DISTRIBUTEDLOCK_ATTRIBUTE);
        }
        return distributedLockOp;
    }

    protected Object getDistributedLockKey(Method method, @Nullable Class<?> targetClass) {
        return new MethodClassKey(method, targetClass);
    }

    @Nullable
    private DistributedLockOperation computeDistributedLockOperation(Method method, @Nullable Class<?> targetClass) {
        if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        Method specificMethod = AopUtils.getMostSpecificMethod((Method)method, targetClass);
        DistributedLockOperation opDef = this.findDistributedLockOperation(specificMethod);
        if (opDef != null) {
            return opDef;
        }
        if (specificMethod != method) {
            opDef = this.findDistributedLockOperation(method);
            return opDef;
        }
        return null;
    }

    @Nullable
    protected abstract DistributedLockOperation findDistributedLockOperation(Method var1);

    protected boolean allowPublicMethodsOnly() {
        return false;
    }
}

