/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.distributedlock.interceptor;

import com.cntaiping.ec.cloud.common.distributedlock.annotations.DistributedLockAnnotationParser;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.AbstractFallbackDistributedLockOperationSource;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.DistributedLockOperation;
import com.cntaiping.ec.cloud.common.distributedlock.interceptor.SpringDistributedLockAnnotationParser;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AnnotationDistributedLockOperationSource
extends AbstractFallbackDistributedLockOperationSource
implements Serializable {
    private final boolean publicMethodsOnly;
    private final Set<DistributedLockAnnotationParser> annotationParsers;

    public AnnotationDistributedLockOperationSource() {
        this(true);
    }

    public AnnotationDistributedLockOperationSource(boolean publicMethodsOnly) {
        this.publicMethodsOnly = publicMethodsOnly;
        this.annotationParsers = Collections.singleton(new SpringDistributedLockAnnotationParser());
    }

    public AnnotationDistributedLockOperationSource(DistributedLockAnnotationParser annotationParser) {
        this.publicMethodsOnly = true;
        Assert.notNull((Object)annotationParser, (String)"DistributedLockAnnotationParser must not be null");
        this.annotationParsers = Collections.singleton(annotationParser);
    }

    public AnnotationDistributedLockOperationSource(DistributedLockAnnotationParser ... annotationParsers) {
        this.publicMethodsOnly = true;
        Assert.notEmpty((Object[])annotationParsers, (String)"At least one DistributedLockAnnotationParser needs to be specified");
        this.annotationParsers = new LinkedHashSet<DistributedLockAnnotationParser>(Arrays.asList(annotationParsers));
    }

    public AnnotationDistributedLockOperationSource(Set<DistributedLockAnnotationParser> annotationParsers) {
        this.publicMethodsOnly = true;
        Assert.notEmpty(annotationParsers, (String)"At least one DistributedLockAnnotationParser needs to be specified");
        this.annotationParsers = annotationParsers;
    }

    @Override
    public boolean isCandidateClass(Class<?> targetClass) {
        for (DistributedLockAnnotationParser parser : this.annotationParsers) {
            if (!parser.isCandidateClass(targetClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected DistributedLockOperation findDistributedLockOperation(Method method) {
        return this.determineDistributedLockOperation(parser -> parser.parseDistributedLockAnnotation(method));
    }

    @Nullable
    protected DistributedLockOperation determineDistributedLockOperation(DistributedLockOperationProvider provider) {
        for (DistributedLockAnnotationParser parser : this.annotationParsers) {
            DistributedLockOperation annOp = provider.getDistributedLockOperation(parser);
            if (annOp == null) continue;
            return annOp;
        }
        return null;
    }

    @Override
    protected boolean allowPublicMethodsOnly() {
        return this.publicMethodsOnly;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotationDistributedLockOperationSource)) {
            return false;
        }
        AnnotationDistributedLockOperationSource otherCos = (AnnotationDistributedLockOperationSource)other;
        return this.annotationParsers.equals(otherCos.annotationParsers) && this.publicMethodsOnly == otherCos.publicMethodsOnly;
    }

    public int hashCode() {
        return this.annotationParsers.hashCode();
    }

    @FunctionalInterface
    protected static interface DistributedLockOperationProvider {
        @Nullable
        public DistributedLockOperation getDistributedLockOperation(DistributedLockAnnotationParser var1);
    }
}

